% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm-classify.R
\name{llm_classify}
\alias{llm_classify}
\alias{llm_vec_classify}
\title{Categorize data as one of options given}
\usage{
llm_classify(
  .data,
  col,
  labels,
  pred_name = ".classify",
  additional_prompt = ""
)

llm_vec_classify(x, labels, additional_prompt = "", preview = FALSE)
}
\arguments{
\item{.data}{A \code{data.frame} or \code{tbl} object that contains the text to be
analyzed}

\item{col}{The name of the field to analyze, supports \code{tidy-eval}}

\item{labels}{A character vector with at least 2 labels to classify the text
as}

\item{pred_name}{A character vector with the name of the new column where the
prediction will be placed}

\item{additional_prompt}{Inserts this text into the prompt sent to the LLM}

\item{x}{A vector that contains the text to be analyzed}

\item{preview}{It returns the R call that would have been used to run the
prediction. It only returns the first record in \code{x}. Defaults to \code{FALSE}
Applies to vector function only.}
}
\value{
\code{llm_classify} returns a \code{data.frame} or \code{tbl} object.
\code{llm_vec_classify} returns a vector that is the same length as \code{x}.
}
\description{
Use a Large Language Model (LLM) to classify the provided text as one of the
options provided via the \code{labels} argument.
}
\examples{
\donttest{
library(mall)

data("reviews")

llm_use("ollama", "llama3.2", seed = 100, .silent = TRUE)

llm_classify(reviews, review, c("appliance", "computer"))

# Use 'pred_name' to customize the new column's name
llm_classify(
  reviews,
  review,
  c("appliance", "computer"),
  pred_name = "prod_type"
)

# Pass custom values for each classification
llm_classify(reviews, review, c("appliance" ~ 1, "computer" ~ 2))

# For character vectors, instead of a data frame, use this function
llm_vec_classify(
  c("this is important!", "just whenever"),
  c("urgent", "not urgent")
)

# To preview the first call that will be made to the downstream R function
llm_vec_classify(
  c("this is important!", "just whenever"),
  c("urgent", "not urgent"),
  preview = TRUE
)
}
}
