% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examples.R
\name{run_example}
\alias{run_example}
\title{Run MAIDR Example Plots}
\usage{
run_example(example = NULL, type = c("ggplot2", "base_r"))
}
\arguments{
\item{example}{Character string specifying which example to run. If `NULL`
(the default), lists all available examples.}

\item{type}{Character string specifying the plot system to use.
Either `"ggplot2"` (default) or `"base_r"`.}
}
\value{
Invisibly returns `NULL`. Called for its side effect of displaying
  an interactive plot in the browser or listing available examples.
}
\description{
Launches example plots demonstrating MAIDR's accessible visualization
capabilities. Each example creates an interactive plot using `show()`.
}
\details{
Available examples include various plot types such as bar charts,
histograms, scatter plots, line plots, boxplots, heatmaps, and more.

Each example script creates a plot and calls `show()` to display it
in your default web browser with full MAIDR accessibility features
including keyboard navigation and screen reader support.
}
\examples{
# List all available examples
run_example()

if (interactive()) {
  # Run ggplot2 bar chart example
  run_example("bar")

  # Run Base R histogram example
  run_example("histogram", type = "base_r")
}

}
\seealso{
[show()] for displaying plots, [save_html()] for saving to file
}
