% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_r_line_layer_processor.R
\name{BaseRLineLayerProcessor}
\alias{BaseRLineLayerProcessor}
\title{Base R Line Plot Layer Processor}
\description{
Processes Base R line plot layers based on recorded plot calls
}
\keyword{Get}
\keyword{LOW-level}
\keyword{axis}
\keyword{axis()}
\keyword{calls}
\keyword{custom}
\keyword{from}
\keyword{internal}
\keyword{labels}
\section{Super class}{
\code{\link[maidr:LayerProcessor]{maidr::LayerProcessor}} -> \code{BaseRLineLayerProcessor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BaseRLineLayerProcessor-process}{\code{BaseRLineLayerProcessor$process()}}
\item \href{#method-BaseRLineLayerProcessor-needs_reordering}{\code{BaseRLineLayerProcessor$needs_reordering()}}
\item \href{#method-BaseRLineLayerProcessor-extract_data}{\code{BaseRLineLayerProcessor$extract_data()}}
\item \href{#method-BaseRLineLayerProcessor-get_axis_labels}{\code{BaseRLineLayerProcessor$get_axis_labels()}}
\item \href{#method-BaseRLineLayerProcessor-extract_single_line_data}{\code{BaseRLineLayerProcessor$extract_single_line_data()}}
\item \href{#method-BaseRLineLayerProcessor-extract_multiline_data}{\code{BaseRLineLayerProcessor$extract_multiline_data()}}
\item \href{#method-BaseRLineLayerProcessor-extract_axis_titles}{\code{BaseRLineLayerProcessor$extract_axis_titles()}}
\item \href{#method-BaseRLineLayerProcessor-extract_abline_data}{\code{BaseRLineLayerProcessor$extract_abline_data()}}
\item \href{#method-BaseRLineLayerProcessor-get_x_range_from_group}{\code{BaseRLineLayerProcessor$get_x_range_from_group()}}
\item \href{#method-BaseRLineLayerProcessor-get_y_range_from_group}{\code{BaseRLineLayerProcessor$get_y_range_from_group()}}
\item \href{#method-BaseRLineLayerProcessor-extract_main_title}{\code{BaseRLineLayerProcessor$extract_main_title()}}
\item \href{#method-BaseRLineLayerProcessor-generate_selectors}{\code{BaseRLineLayerProcessor$generate_selectors()}}
\item \href{#method-BaseRLineLayerProcessor-find_lines_grobs}{\code{BaseRLineLayerProcessor$find_lines_grobs()}}
\item \href{#method-BaseRLineLayerProcessor-generate_selectors_from_grob}{\code{BaseRLineLayerProcessor$generate_selectors_from_grob()}}
\item \href{#method-BaseRLineLayerProcessor-clone}{\code{BaseRLineLayerProcessor$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="apply_scale_mapping"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-apply_scale_mapping'><code>maidr::LayerProcessor$apply_scale_mapping()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="extract_layer_axes"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-extract_layer_axes'><code>maidr::LayerProcessor$extract_layer_axes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="get_last_result"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-get_last_result'><code>maidr::LayerProcessor$get_last_result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="get_layer_index"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-get_layer_index'><code>maidr::LayerProcessor$get_layer_index()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="initialize"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-initialize'><code>maidr::LayerProcessor$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="reorder_layer_data"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-reorder_layer_data'><code>maidr::LayerProcessor$reorder_layer_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="set_last_result"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-set_last_result'><code>maidr::LayerProcessor$set_last_result()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-process"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-process}{}}}
\subsection{Method \code{process()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$process(
  plot,
  layout,
  built = NULL,
  gt = NULL,
  scale_mapping = NULL,
  grob_id = NULL,
  panel_id = NULL,
  panel_ctx = NULL,
  layer_info = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-needs_reordering"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-needs_reordering}{}}}
\subsection{Method \code{needs_reordering()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$needs_reordering()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-extract_data"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-extract_data}{}}}
\subsection{Method \code{extract_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$extract_data(layer_info)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-get_axis_labels"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-get_axis_labels}{}}}
\subsection{Method \code{get_axis_labels()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$get_axis_labels(layer_info, axis_side = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer_info}}{Layer information containing group data}

\item{\code{axis_side}}{Which axis (1=bottom/x, 2=left/y, 3=top, 4=right)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Character vector of labels or NULL if not found
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-extract_single_line_data"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-extract_single_line_data}{}}}
\subsection{Method \code{extract_single_line_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$extract_single_line_data(x, y, x_labels = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-extract_multiline_data"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-extract_multiline_data}{}}}
\subsection{Method \code{extract_multiline_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$extract_multiline_data(x, y_matrix, x_labels = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-extract_axis_titles"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-extract_axis_titles}{}}}
\subsection{Method \code{extract_axis_titles()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$extract_axis_titles(layer_info)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-extract_abline_data"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-extract_abline_data}{}}}
\subsection{Method \code{extract_abline_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$extract_abline_data(layer_info)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-get_x_range_from_group"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-get_x_range_from_group}{}}}
\subsection{Method \code{get_x_range_from_group()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$get_x_range_from_group(group)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-get_y_range_from_group"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-get_y_range_from_group}{}}}
\subsection{Method \code{get_y_range_from_group()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$get_y_range_from_group(group)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-extract_main_title"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-extract_main_title}{}}}
\subsection{Method \code{extract_main_title()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$extract_main_title(layer_info)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-generate_selectors"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-generate_selectors}{}}}
\subsection{Method \code{generate_selectors()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$generate_selectors(layer_info, gt = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-find_lines_grobs"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-find_lines_grobs}{}}}
\subsection{Method \code{find_lines_grobs()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$find_lines_grobs(
  grob,
  group_index,
  grob_type = "lines"
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-generate_selectors_from_grob"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-generate_selectors_from_grob}{}}}
\subsection{Method \code{generate_selectors_from_grob()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$generate_selectors_from_grob(
  grob,
  group_index,
  layer_info
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRLineLayerProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRLineLayerProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRLineLayerProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
