% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_api_processor.R
\name{BaseAPIProcessor}
\alias{BaseAPIProcessor}
\title{Base API Processor Class}
\description{
Base API Processor Class

Base API Processor Class
}
\details{
Abstract base class for API processors that provides common functionality
including unified logging, error handling, input processing, and response validation.
This eliminates code duplication across all provider-specific processors.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{provider_name}}{Name of the API provider}

\item{\code{logger}}{Unified logger instance}

\item{\code{base_url}}{Custom base URL for API endpoints}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BaseAPIProcessor-new}{\code{BaseAPIProcessor$new()}}
\item \href{#method-BaseAPIProcessor-process_request}{\code{BaseAPIProcessor$process_request()}}
\item \href{#method-BaseAPIProcessor-get_api_url}{\code{BaseAPIProcessor$get_api_url()}}
\item \href{#method-BaseAPIProcessor-get_default_api_url}{\code{BaseAPIProcessor$get_default_api_url()}}
\item \href{#method-BaseAPIProcessor-make_api_call}{\code{BaseAPIProcessor$make_api_call()}}
\item \href{#method-BaseAPIProcessor-extract_response_content}{\code{BaseAPIProcessor$extract_response_content()}}
\item \href{#method-BaseAPIProcessor-clone}{\code{BaseAPIProcessor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseAPIProcessor-new"></a>}}
\if{latex}{\out{\hypertarget{method-BaseAPIProcessor-new}{}}}
\subsection{Method \code{new()}}{
Initialize the base API processor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseAPIProcessor$new(provider_name, base_url = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{provider_name}}{Name of the API provider (e.g., "openai", "anthropic")}

\item{\code{base_url}}{Optional custom base URL for API endpoints}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseAPIProcessor-process_request"></a>}}
\if{latex}{\out{\hypertarget{method-BaseAPIProcessor-process_request}{}}}
\subsection{Method \code{process_request()}}{
Main entry point for processing API requests
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseAPIProcessor$process_request(prompt, model, api_key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt}}{Input prompt text}

\item{\code{model}}{Model identifier}

\item{\code{api_key}}{API key for authentication}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Processed response as character vector
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseAPIProcessor-get_api_url"></a>}}
\if{latex}{\out{\hypertarget{method-BaseAPIProcessor-get_api_url}{}}}
\subsection{Method \code{get_api_url()}}{
Get the API URL to use for requests
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseAPIProcessor$get_api_url()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
API URL string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseAPIProcessor-get_default_api_url"></a>}}
\if{latex}{\out{\hypertarget{method-BaseAPIProcessor-get_default_api_url}{}}}
\subsection{Method \code{get_default_api_url()}}{
Abstract method to be implemented by subclasses for getting default API URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseAPIProcessor$get_default_api_url()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Default API URL string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseAPIProcessor-make_api_call"></a>}}
\if{latex}{\out{\hypertarget{method-BaseAPIProcessor-make_api_call}{}}}
\subsection{Method \code{make_api_call()}}{
Abstract method to be implemented by subclasses for making the actual API call
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseAPIProcessor$make_api_call(chunk_content, model, api_key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chunk_content}}{Content for this chunk}

\item{\code{model}}{Model identifier}

\item{\code{api_key}}{API key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Raw API response
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseAPIProcessor-extract_response_content"></a>}}
\if{latex}{\out{\hypertarget{method-BaseAPIProcessor-extract_response_content}{}}}
\subsection{Method \code{extract_response_content()}}{
Abstract method to be implemented by subclasses for extracting content from response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseAPIProcessor$extract_response_content(response, model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{response}}{Raw API response}

\item{\code{model}}{Model identifier}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Extracted text content
Validate input parameters
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseAPIProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BaseAPIProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseAPIProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
