% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-auc.R
\name{luz_metric_multiclass_auroc}
\alias{luz_metric_multiclass_auroc}
\title{Computes the multi-class AUROC}
\usage{
luz_metric_multiclass_auroc(
  num_thresholds = 200,
  thresholds = NULL,
  from_logits = FALSE,
  average = c("micro", "macro", "weighted", "none")
)
}
\arguments{
\item{num_thresholds}{Number of thresholds used to compute confusion matrices.
In that case, thresholds are created by getting \code{num_thresholds} values linearly
spaced in the unit interval.}

\item{thresholds}{(optional) If threshold are passed, then those are used to compute the
confusion matrices and \code{num_thresholds} is ignored.}

\item{from_logits}{If \code{TRUE} then we call \code{\link[torch:nnf_softmax]{torch::nnf_softmax()}} in the predictions
before computing the metric.}

\item{average}{The averaging method:
\itemize{
\item \code{'micro'}: Stack all classes and computes the AUROC as if it was a binary
classification problem.
\item \code{'macro'}: Finds the AUCROC for each class and computes their mean.
\item \code{'weighted'}: Finds the AUROC for each class and computes their weighted
mean pondering by the number of instances for each class.
\item \code{'none'}: Returns the AUROC for each class in a list.
}}
}
\description{
The same definition as \href{https://www.tensorflow.org/api_docs/python/tf/keras/metrics/AUC}{Keras}
is used by default. This is equivalent to the \code{'micro'} method in SciKit Learn
too. See \href{https://scikit-learn.org/stable/modules/generated/sklearn.metrics.roc_auc_score.html}{docs}.
}
\details{
\strong{Note} that class imbalance can affect this metric unlike
the AUC for binary classification.

Currently the AUC is approximated using the 'interpolation' method described in
\href{https://www.tensorflow.org/api_docs/python/tf/keras/metrics/AUC}{Keras}.
}
\examples{
if (torch::torch_is_installed()) {
library(torch)
actual <- c(1, 1, 1, 0, 0, 0) + 1L
predicted <- c(0.9, 0.8, 0.4, 0.5, 0.3, 0.2)
predicted <- cbind(1-predicted, predicted)

y_true <- torch_tensor(as.integer(actual))
y_pred <- torch_tensor(predicted)

m <- luz_metric_multiclass_auroc(thresholds = as.numeric(predicted),
                                 average = "micro")
m <- m$new()

m$update(y_pred[1:2,], y_true[1:2])
m$update(y_pred[3:4,], y_true[3:4])
m$update(y_pred[5:6,], y_true[5:6])
m$compute()
}
}
\seealso{
Other luz_metrics: 
\code{\link{luz_metric}()},
\code{\link{luz_metric_accuracy}()},
\code{\link{luz_metric_binary_accuracy}()},
\code{\link{luz_metric_binary_accuracy_with_logits}()},
\code{\link{luz_metric_binary_auroc}()},
\code{\link{luz_metric_mae}()},
\code{\link{luz_metric_mse}()},
\code{\link{luz_metric_rmse}()}
}
\concept{luz_metrics}
