% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rmpowerequiv}
\alias{rmpowerequiv}
\title{Power for Equivalence in Restricted Mean Survival Time Difference}
\usage{
rmpowerequiv(
  kMax = 1L,
  informationRates = NA_real_,
  criticalValues = NA_real_,
  alpha = 0.05,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  milestone = NA_real_,
  rmstDiffLower = NA_real_,
  rmstDiffUpper = NA_real_,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  spendingTime = NA_real_,
  studyDuration = NA_real_
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates.
Defaults to \code{(1:kMax) / kMax} if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level for each of the two one-sided
tests. Defaults to 0.05.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{milestone}{The milestone time at which to calculate the
restricted mean survival time.}

\item{rmstDiffLower}{The lower equivalence limit of restricted mean
survival time difference.}

\item{rmstDiffUpper}{The upper equivalence limit of restricted mean
survival time difference.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda1}{A vector of hazard rates for the event in each analysis
time interval by stratum for the active treatment group.}

\item{lambda2}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group.}

\item{gamma1}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending
time at each analysis. Defaults to missing, in which case, it is the
same as \code{informationRates}.}

\item{studyDuration}{Study duration for fixed follow-up design.
Defaults to missing, which is to be replaced with the sum of
\code{accrualDuration} and \code{followupTime}. If provided,
the value is allowed to be less than the sum of \code{accrualDuration}
and \code{followupTime}.}
}
\value{
An S3 class \code{rmpowerequiv} object with 4 components:
\itemize{
\item \code{overallResults}: A data frame containing the following variables:
\itemize{
\item \code{overallReject}: The overall rejection probability.
\item \code{alpha}: The overall significance level.
\item \code{numberOfEvents}: The total number of events.
\item \code{numberOfSubjects}: The total number of subjects.
\item \code{studyDuration}: The total study duration.
\item \code{information}: The maximum information.
\item \code{expectedNumberOfEvents}: The expected number of events.
\item \code{expectedNumberOfSubjects}: The expected number of subjects.
\item \code{expectedStudyDuration}: The expected study duration.
\item \code{expectedInformation}: The expected information.
\item \code{kMax}: The number of stages.
\item \code{milestone}: The milestone time relative to randomization.
\item \code{rmstDiffLower}: The lower equivalence limit of restricted
mean survival time difference.
\item \code{rmstDiffUpper}: The upper equivalence limit of restricted
mean survival time difference.
\item \code{rmst1}: The restricted mean survival time for the
treatment group.
\item \code{rmst2}: The restricted mean survival time for the
control group.
\item \code{rmstDiff}: The restricted mean survival time difference.
\item \code{accrualDuration}: The accrual duration.
\item \code{followupTime}: The follow-up duration.
\item \code{fixedFollowup}: Whether a fixed follow-up design is used.
}
\item \code{byStageResults}: A data frame containing the following variables:
\itemize{
\item \code{informationRates}: The information rates.
\item \code{efficacyBounds}: The efficacy boundaries on the Z-scale for
each of the two one-sided tests.
\item \code{rejectPerStage}: The probability for efficacy stopping.
\item \code{cumulativeRejection}: The cumulative probability for efficacy
stopping.
\item \code{cumulativeAlphaSpent}: The cumulative alpha for each of
the two one-sided tests.
\item \code{cumulativeAttainedAlphaH10}: The cumulative alpha attained
under \code{H10}.
\item \code{cumulativeAttainedAlphaH20}: The cumulative alpha attained
under \code{H20}.
\item \code{numberOfEvents}: The number of events.
\item \code{numberOfDropouts}: The number of dropouts.
\item \code{numberOfSubjects}: The number of subjects.
\item \code{numberOfMilestone}: The number of subjects reaching
milestone.
\item \code{analysisTime}: The average time since trial start.
\item \code{efficacyRmstDiffLower}: The efficacy boundaries on the
restricted mean survival time difference scale for the one-sided
null hypothesis at the lower equivalence limit.
\item \code{efficacyRmstDiffUpper}: The efficacy boundaries on the
restricted mean survival time difference scale for the one-sided
null hypothesis at the upper equivalence limit.
\item \code{efficacyP}: The efficacy bounds on the p-value scale for
each of the two one-sided tests.
\item \code{information}: The cumulative information.
}
\item \code{settings}: A list containing the following input parameters:
\code{typeAlphaSpending}, \code{parameterAlphaSpending},
\code{userAlphaSpending}, \code{allocationRatioPlanned},
\code{accrualTime}, \code{accuralIntensity},
\code{piecewiseSurvivalTime}, \code{stratumFraction},
\code{lambda1}, \code{lambda2}, \code{gamma1}, \code{gamma2},
and \code{spendingTime}.
\item \code{byTreatmentCounts}: A list containing the following counts by
treatment group:
\itemize{
\item \code{numberOfEvents1}: The number of events by stage for
the treatment group.
\item \code{numberOfDropouts1}: The number of dropouts by stage for
the treatment group.
\item \code{numberOfSubjects1}: The number of subjects by stage for
the treatment group.
\item \code{numberOfMilestone1}: The number of subjects reaching
milestone by stage for the active treatment group.
\item \code{numberOfEvents2}: The number of events by stage for
the control group.
\item \code{numberOfDropouts2}: The number of dropouts by stage for
the control group.
\item \code{numberOfSubjects2}: The number of subjects by stage for
the control group.
\item \code{numberOfMilestone2}: The number of subjects reaching
milestone by stage for the control group.
\item \code{expectedNumberOfEvents1}: The expected number of events for
the treatment group.
\item \code{expectedNumberOfDropouts1}: The expected number of dropouts
for the active treatment group.
\item \code{expectedNumberOfSubjects1}: The expected number of subjects
for the active treatment group.
\item \code{expectedNumberOfMilestone1}: The expected number of subjects
reaching milestone for the active treatment group.
\item \code{expectedNumberOfEvents2}: The expected number of events for
control group.
\item \code{expectedNumberOfDropouts2}: The expected number of dropouts
for the control group.
\item \code{expectedNumberOfSubjects2}: The expected number of subjects
for the control group.
\item \code{expectedNumberOfMilestone2}: The expected number of subjects
reaching milestone for the control group.
}
}
}
\description{
Obtains the power for equivalence in restricted mean
survival time difference.
}
\examples{

rmpowerequiv(kMax = 2, informationRates = c(0.5, 1),
             alpha = 0.05, typeAlphaSpending = "sfOF",
             milestone = 18,
             rmstDiffLower = -2, rmstDiffUpper = 2,
             allocationRatioPlanned = 1, accrualTime = seq(0, 8),
             accrualIntensity = 100/9*seq(1, 9),
             piecewiseSurvivalTime = c(0, 6),
             stratumFraction = c(0.2, 0.8),
             lambda1 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
             lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
             gamma1 = -log(1-0.05)/12,
             gamma2 = -log(1-0.05)/12, accrualDuration = 22,
             followupTime = 18, fixedFollowup = FALSE)

}
\seealso{
\code{\link{rmstat}}
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
