% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{getDesignRiskRatio}
\alias{getDesignRiskRatio}
\title{Group Sequential Design for Two-Sample Risk Ratio}
\usage{
getDesignRiskRatio(
  beta = NA_real_,
  n = NA_real_,
  riskRatioH0 = 1,
  pi1 = NA_real_,
  pi2 = NA_real_,
  nullVariance = TRUE,
  allocationRatioPlanned = 1,
  rounding = TRUE,
  kMax = 1L,
  informationRates = NA_real_,
  efficacyStopping = NA_integer_,
  futilityStopping = NA_integer_,
  criticalValues = NA_real_,
  alpha = 0.025,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  futilityBounds = NA_real_,
  typeBetaSpending = "none",
  parameterBetaSpending = NA_real_,
  userBetaSpending = NA_real_,
  spendingTime = NA_real_
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{riskRatioH0}{The risk ratio under the null hypothesis.
Defaults to 1.}

\item{pi1}{The assumed probability for the active treatment group.}

\item{pi2}{The assumed probability for the control group.}

\item{nullVariance}{Whether to use the variance under the null or
the empirical variance under the alternative.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates. Fixed prior to the trial.
Defaults to \code{(1:kMax) / kMax} if left unspecified.}

\item{efficacyStopping}{Indicators of whether efficacy stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{futilityStopping}{Indicators of whether futility stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level. Defaults to 0.025.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{futilityBounds}{Lower boundaries on the z-test statistic scale
for stopping for futility at stages 1, ..., \code{kMax-1}. Defaults to
\code{rep(-6, kMax-1)} if left unspecified. The futility bounds are
non-binding for the calculation of critical values.}

\item{typeBetaSpending}{The type of beta spending. One of the following:
"sfOF" for O'Brien-Fleming type spending function, "sfP" for Pocock type
spending function, "sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, "user" for
user defined spending, and "none" for no early futility stopping.
Defaults to "none".}

\item{parameterBetaSpending}{The parameter value for the beta spending.
Corresponds to rho for "sfKD", and gamma for "sfHSD".}

\item{userBetaSpending}{The user defined beta spending. Cumulative beta
spent up to each stage.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending
time at each analysis. Defaults to missing, in which case, it is the
same as \code{informationRates}.}
}
\value{
An S3 class \code{designRiskRatio} object with three components:
\itemize{
\item \code{overallResults}: A data frame containing the following variables:
\itemize{
\item \code{overallReject}: The overall rejection probability.
\item \code{alpha}: The overall significance level.
\item \code{attainedAlpha}: The attained significance level, which is
different from the overall significance level in the presence of
futility stopping.
\item \code{kMax}: The number of stages.
\item \code{theta}: The parameter value.
\item \code{information}: The maximum information.
\item \code{expectedInformationH1}: The expected information under H1.
\item \code{expectedInformationH0}: The expected information under H0.
\item \code{drift}: The drift parameter, equal to
\code{theta*sqrt(information)}.
\item \code{inflationFactor}: The inflation factor (relative to the
fixed design).
\item \code{numberOfSubjects}: The maximum number of subjects.
\item \code{expectedNumberOfSubjectsH1}: The expected number of subjects
under H1.
\item \code{expectedNumberOfSubjectsH0}: The expected number of subjects
under H0.
\item \code{riskRatioH0}: The risk ratio under the null hypothesis.
\item \code{pi1}: The assumed probability for the active treatment group.
\item \code{pi2}: The assumed probability for the control group.
}
\item \code{byStageResults}: A data frame containing the following variables:
\itemize{
\item \code{informationRates}: The information rates.
\item \code{efficacyBounds}: The efficacy boundaries on the Z-scale.
\item \code{futilityBounds}: The futility boundaries on the Z-scale.
\item \code{rejectPerStage}: The probability for efficacy stopping.
\item \code{futilityPerStage}: The probability for futility stopping.
\item \code{cumulativeRejection}: The cumulative probability for efficacy
stopping.
\item \code{cumulativeFutility}: The cumulative probability for futility
stopping.
\item \code{cumulativeAlphaSpent}: The cumulative alpha spent.
\item \code{efficacyP}: The efficacy boundaries on the p-value scale.
\item \code{futilityP}: The futility boundaries on the p-value scale.
\item \code{information}: The cumulative information.
\item \code{efficacyStopping}: Whether to allow efficacy stopping.
\item \code{futilityStopping}: Whether to allow futility stopping.
\item \code{rejectPerStageH0}: The probability for efficacy stopping
under H0.
\item \code{futilityPerStageH0}: The probability for futility stopping
under H0.
\item \code{cumulativeRejectionH0}: The cumulative probability for
efficacy stopping under H0.
\item \code{cumulativeFutilityH0}: The cumulative probability for futility
stopping under H0.
\item \code{efficacyRiskRatio}: The efficacy boundaries on the risk
ratio scale.
\item \code{futilityRiskRatio}: The futility boundaries on the risk
ratio scale.
\item \code{numberOfSubjects}: The number of subjects.
}
\item \code{settings}: A list containing the following input parameters:
\itemize{
\item \code{typeAlphaSpending}: The type of alpha spending.
\item \code{parameterAlphaSpending}: The parameter value for alpha
spending.
\item \code{userAlphaSpending}: The user defined alpha spending.
\item \code{typeBetaSpending}: The type of beta spending.
\item \code{parameterBetaSpending}: The parameter value for beta spending.
\item \code{userBetaSpending}: The user defined beta spending.
\item \code{spendingTime}: The error spending time at each analysis.
\item \code{varianceRatio}: The ratio of the variance under H0 to
the variance under H1.
\item \code{nullVariance}: Whether to use the variance under the null or
the empirical variance under the alternative.
\item \code{allocationRatioPlanned}: Allocation ratio for the active
treatment versus control.
\item \code{rounding}: Whether to round up sample size.
}
}
}
\description{
Obtains the power given sample size or obtains the sample
size given power for a group sequential design for two-sample risk
ratio.
}
\details{
Consider a group sequential design for two-sample risk ratio.
The parameter of interest is \deqn{\rho = \pi_1 / \pi_2}
where \eqn{\pi_1} is the response probability for the active
treatment group and \eqn{\pi_2} is the response probability
for the control group. For statistical inference,
the parameter is often transformed to
the log scale: \deqn{\theta = \log(\rho) = \log(\pi_1) - \log(\pi_2)}
The variance of the estimator \eqn{\hat{\theta}}
can be derived from the binomial distributions as follows:
\deqn{Var(\hat{\theta}) = \frac{1}{n} \{
\frac{1-\pi_1}{\pi_1 r} + \frac{1-\pi_2}{\pi_2(1-r)} \}}
where \eqn{n} is the total number of subjects and \eqn{r} is the
randomization probability for the active treatment group.
When \code{nullVariance = TRUE}, the variance is computed
under the null hypothesis. In this case, the values of
\eqn{\pi_1} and \eqn{\pi_2} in the variance formula are
replaced with their restricted maximum likelihood
counterparts, subject to the constraint
\deqn{\pi_1 / \pi_2 = \rho_0}
}
\examples{

(design1 <- getDesignRiskRatio(
  beta = 0.1, n = NA, pi1 = 0.5, pi2 = 0.3,
  alpha = 0.05))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
