% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{fseqbon}
\alias{fseqbon}
\title{Group Sequential Trials Using Bonferroni-Based Graphical
Approaches}
\usage{
fseqbon(
  w,
  G,
  alpha = 0.025,
  kMax,
  typeAlphaSpending = NULL,
  parameterAlphaSpending = NULL,
  incidenceMatrix = NULL,
  maxInformation = NULL,
  p,
  information,
  spendingTime = NULL
)
}
\arguments{
\item{w}{The vector of initial weights for elementary hypotheses.}

\item{G}{The initial transition matrix.}

\item{alpha}{The significance level. Defaults to 0.025.}

\item{kMax}{The maximum number of stages.}

\item{typeAlphaSpending}{The vector of alpha spending functions.
Each element is one of the following:
"OF" for O'Brien-Fleming boundaries,
"P" for Pocock boundaries, "WT" for Wang & Tsiatis boundaries,
"sfOF" for O'Brien-Fleming type spending function,
"sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function,
and "none" for no early efficacy stopping.
Defaults to "sfOF" if not provided.}

\item{parameterAlphaSpending}{The vector of parameter values for the
alpha spending functions. Each element corresponds to the value of
Delta for "WT", rho for "sfKD", or gamma for "sfHSD".
Defaults to missing if not provided.}

\item{incidenceMatrix}{The incidence matrix indicating whether the
specific hypothesis will be tested at the given look. The number of
columns of incidenceMatrix must be equal to the maximum number of
study looks (\code{kMax}). If not provided, defaults to testing each
hypothesis at all study looks.}

\item{maxInformation}{The vector of target maximum information for each
hypothesis. Defaults to a vector of 1s if not provided.}

\item{p}{The matrix of raw p-values for each hypothesis by study look.}

\item{information}{The matrix of observed information for each hypothesis
by study look.}

\item{spendingTime}{The spending time for alpha spending by study look.
If not provided, it is the same as \code{informationRates} calculated
from \code{information} and \code{maxInformation}.}
}
\value{
A vector to indicate the first look the specific hypothesis is
rejected (0 if the hypothesis is not rejected).
}
\description{
Obtains the test results for group sequential trials using
graphical approaches based on weighted Bonferroni tests.
}
\examples{

# Case study from Maurer & Bretz (2013)

fseqbon(
  w = c(0.5, 0.5, 0, 0),
  G = matrix(c(0, 0.5, 0.5, 0,  0.5, 0, 0, 0.5,
               0, 1, 0, 0,  1, 0, 0, 0),
             nrow=4, ncol=4, byrow=TRUE),
  alpha = 0.025,
  kMax = 3,
  typeAlphaSpending = rep("sfOF", 4),
  maxInformation = rep(1, 4),
  p = matrix(c(0.0062, 0.017, 0.009, 0.13,
               0.0002, 0.0035, 0.002, 0.06),
             nrow=4, ncol=2),
  information = matrix(c(rep(1/3, 4), rep(2/3, 4)),
                       nrow=4, ncol=2))


}
\references{
Willi Maurer and Frank Bretz. Multiple testing in group sequential
trials using graphical approaches. Statistics in Biopharmaceutical
Research. 2013; 5:311-320.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
