% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_clients.R
\name{lob_list_clients}
\alias{lob_list_clients}
\title{List Lobbying Filings}
\usage{
lob_list_clients(
  client_country = NULL,
  client_name = NULL,
  client_ppb_country = NULL,
  client_ppb_state = NULL,
  client_state = NULL,
  id = NULL,
  ordering = NULL,
  page = NULL,
  page_size = NULL,
  registrant_id = NULL,
  registrant_name = NULL,
  clean = TRUE
)
}
\arguments{
\item{client_country}{Client Country. Such as "US" or "CA".}

\item{client_name}{Client Name. String value.}

\item{client_ppb_country}{Client PPB Country. Such as "US" or "CA".}

\item{client_ppb_state}{Client PPB State. Such as "AL" or "AK".}

\item{client_state}{Client State. Such as "AL" or "AK".}

\item{id}{ID. Integer value.}

\item{ordering}{Which field to use when ordering the results. String value.}

\item{page}{A page number within the paginated result set. Integer value.}

\item{page_size}{Number of results to return per page. Integer value.}

\item{registrant_id}{Registrant ID. Integer value.}

\item{registrant_name}{Registrant Name. String value.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or list.}
}
\value{
a \code{tibble} of clients
}
\description{
List Lobbying Filings
}
\examples{
\dontshow{if (has_lobby_key()) withAutoprint(\{ # examplesIf}
lob_list_clients(client_country = 'US')
\dontshow{\}) # examplesIf}
}
