% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{slic}
\alias{slic}
\title{Segment image into superpixels}
\usage{
slic(L, a, b, n_sp, weight, n_iter)
}
\arguments{
\item{L, a, b}{Raw matrices giving the L, a, and b component of each pixel in
the image to segment. The dimensions of all matrices must match.}

\item{n_sp}{The number of superpixels to segment the image into}

\item{weight}{A numeric giving the tradeoff between spatial and colour
distance. Higher values give more compact and heterogeneous superpixels,
while lower values will give superpixels of more irregular shape but with a
more homogeneous colour. Good values to start with is 10-20.}

\item{n_iter}{The number of iterations to run the algorithm for. The authors
suggest 10 and increasing it doesn't add much.}
}
\value{
An integer matrix of the same dimensions as \code{L}, \code{a}, and \code{b},
indexing each pixel into its corresponding superpixel
}
\description{
This is an implementation of the SLIC superpixel algorithm for
segmenting images into connected similar patches. It is used by lime for
permuting image input but exported so that others might use it for other
things
}
\keyword{internal}
