% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{unconstrained_fit_default}
\alias{unconstrained_fit_default}
\title{Unconstrained Generalized Linear Model Estimation}
\usage{
unconstrained_fit_default(
  X,
  y,
  LambdaHalf,
  Lambda,
  keep_weighted_Lambda,
  family,
  tol,
  K,
  parallel,
  cl,
  chunk_size,
  num_chunks,
  rem_chunks,
  order_indices,
  weights,
  ...
)
}
\arguments{
\item{X}{Design matrix of predictors}

\item{y}{Response variable vector}

\item{LambdaHalf}{Square root of penalty matrix (\eqn{\boldsymbol{\Lambda}^{1/2}})}

\item{Lambda}{Penalty matrix (\eqn{\boldsymbol{\Lambda}})}

\item{keep_weighted_Lambda}{Logical flag to control penalty matrix handling:
- `TRUE`: Return coefficients directly from weighted penalty fitting
- `FALSE`: Apply damped Newton-Raphson optimization to refine estimates}

\item{family}{Distribution family specification}

\item{tol}{Convergence tolerance}

\item{K}{Number of partitions minus one (\eqn{K})}

\item{parallel}{Flag for parallel processing}

\item{cl}{Cluster object for parallel computation}

\item{chunk_size}{Processing chunk size}

\item{num_chunks}{Number of computational chunks}

\item{rem_chunks}{Remaining chunks}

\item{order_indices}{Observation ordering indices}

\item{weights}{Optional observation weights}

\item{...}{Additional arguments passed to \code{glm.fit}}
}
\value{
Optimized parameter estimates for canonical generalized linear models.

For fitting non-canonical GLMs, use \code{keep_weighted_Lambda = TRUE} since the
score and hessian equations below are no longer valid.

For Gamma(link='log') using \code{keep_weighted_Lambda = TRUE} is misleading.
The information is weighted by a constant (shape parameter) rather than some
mean-variance relationship. So \code{keep_weighted_Lambda = TRUE} is highly
recommended for log-link Gamma models. This constant flushes into the
penalty terms, and so the formulation of the information matrix is valid.

For other scenarios, like probit regression, there will be diagonal weights
incorporated into the penalty matrix for providing initial MLE estimates,
which technically imposes a prior distribution on beta coefficients that
isn't by intent.

Heuristically, it shouldn't affect much, as these will be updated to their
proper form when providing estimates under constraint; lgspline otherwise
does use the correct form of score and information afterwards,
regardless of canonical/non-canonical status,
as long as 'glm_weight_function' and 'qp_score_function' are properly specified.
}
\description{
Fits generalized linear models without smoothing constraints
using penalized maximum likelihood estimation. This is applied to each
partition to obtain the unconstrained estimates, prior to imposing the
smoothing constraints.
}
\keyword{internal}
