% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_model_s3.R
\docType{class}
\name{ldmppr_mark_model}
\alias{ldmppr_mark_model}
\alias{print.ldmppr_mark_model}
\alias{predict.ldmppr_mark_model}
\alias{save_mark_model}
\alias{save_mark_model.ldmppr_mark_model}
\alias{load_mark_model}
\title{Mark model object}
\usage{
ldmppr_mark_model(
  engine,
  fit_engine = NULL,
  xgb_raw = NULL,
  recipe = NULL,
  outcome = "size",
  feature_names = NULL,
  info = list()
)

\method{print}{ldmppr_mark_model}(x, ...)

predict.ldmppr_mark_model(object, new_data, ...)

save_mark_model(object, path, ...)

\method{save_mark_model}{ldmppr_mark_model}(object, path, ...)

load_mark_model(path)
}
\arguments{
\item{engine}{character string (currently \code{"xgboost"} and \code{"ranger"}).}

\item{fit_engine}{fitted engine object (e.g. \code{xgb.Booster} or a ranger fit).}

\item{xgb_raw}{raw xgboost payload (e.g. UBJ) used for rehydration.}

\item{recipe}{a prepped recipes object used for preprocessing new data.}

\item{outcome}{outcome column name (default \code{"size"}).}

\item{feature_names}{(optional) vector of predictor names required at prediction time.}

\item{info}{(optional) list of metadata.}

\item{x}{a \code{ldmppr_mark_model} object.}

\item{...}{passed to methods.}

\item{object}{a \code{ldmppr_mark_model} object.}

\item{new_data}{a data frame of predictors (and possibly outcome columns).}

\item{path}{path to an \code{.rds} created by \code{\link{save_mark_model}} (or legacy objects).}
}
\value{
\describe{
   \item{\code{print()}}{prints a brief summary.}
   \item{\code{predict()}}{returns numeric predictions for new data.}
}

an object of class \code{"ldmppr_mark_model"}.
}
\description{
\code{ldmppr_mark_model} objects store a fitted mark model and preprocessing
information used to predict marks at new locations and times.
These objects are typically returned by \code{\link{train_mark_model}} and can be
saved/loaded with \code{\link{save_mark_model}} and \code{\link{load_mark_model}}.
}
\details{
The model may be backed by different engines (currently \code{"xgboost"} and
\code{"ranger"}). For \code{"xgboost"}, the object can store a serialized booster payload
to make saving/loading robust across R sessions.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(ldmppr_mark_model)}: Print a brief summary of the mark model.

\item \code{save_mark_model(ldmppr_mark_model)}: Save method for \code{ldmppr_mark_model}.

}}
\section{Functions}{
\itemize{
\item \code{ldmppr_mark_model()}: Create a mark model container.

\item \code{predict.ldmppr_mark_model()}: Predict marks for new data.

\item \code{save_mark_model()}: Save a mark model to disk.

\item \code{load_mark_model()}: Load a saved mark model from disk.

}}
