% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_kim.R
\name{correlation_kim}
\alias{correlation_kim}
\title{Estimate the correlation between two variables}
\usage{
correlation_kim(
  x = NULL,
  y = NULL,
  data = NULL,
  x_var_name = NULL,
  y_var_name = NULL,
  ci_range = 0.95,
  round_r = 2,
  round_p = 3,
  output_type = "summary"
)
}
\arguments{
\item{x}{a numeric vector of data values}

\item{y}{a numeric vector of data values}

\item{data}{(optional) a data object (a data frame or a data.table)}

\item{x_var_name}{(optional) name of the first variable
(if using a data set as an input)}

\item{y_var_name}{(optional) name of the second variable
(if using a data set as an input)}

\item{ci_range}{range of the confidence interval for the correlation
coefficient. If \code{ci_range = FALSE}, no confidence interval
will be estimated. By default, \code{ci_range = 0.95}.}

\item{round_r}{number of decimal places to which to round
correlation coefficients (default = 2)}

\item{round_p}{number of decimal places to which to round
p-values (default = 3)}

\item{output_type}{type of the output. If \code{output_type = "dt"},
the function's output will be a data.table with the results from the
correlation analysis. If \code{output_type = "summary"}, the function's
output will be a statement (a string) summarizing the results from
the correlation analysis. By default, \code{output_type = "summary"}}
}
\description{
Estimate the correlation between two variables
}
\examples{
\dontrun{
correlation_kim(x = 1:4, y = c(1, 3, 2, 4))
correlation_kim(x = 1:4, y = c(1, 3, 2, 4), ci_range = FALSE)
# output as a data table
correlation_kim(x = 1:4, y = c(1, 3, 2, 4), output_type = "dt")
}
}
