% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate_lsmeans.R
\name{tabulate_lsmeans}
\alias{tabulate_lsmeans}
\alias{tidy.tern_model}
\alias{s_lsmeans}
\alias{a_lsmeans}
\title{Tabulation of Least Square Means Results}
\usage{
\method{tidy}{tern_model}(x, ...)

s_lsmeans(
  df,
  .in_ref_col,
  alternative = c("two.sided", "less", "greater"),
  show_relative = c("reduction", "increase")
)

a_lsmeans(
  df,
  ref_path,
  .spl_context,
  ...,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{...}{additional arguments for the lower level functions.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.in_ref_col}{(\code{logical})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}

\item{alternative}{(\code{string})\cr whether \code{two.sided}, or one-sided \code{less} or \code{greater} p-value
should be displayed.}

\item{show_relative}{(\code{string})\cr should the 'reduction' (\code{control - treatment}, default) or the 'increase'
(\code{treatment - control}) be shown for the relative change from baseline?}

\item{ref_path}{(\code{character})\cr global reference group specification, see \code{\link[=get_ref_info]{get_ref_info()}}.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{'auto'} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}
}
\value{
\itemize{
\item For \code{s_lsmeans}, a list containing the same statistics returned by tern.mmrm::s_mmrm_lsmeans,
with the additional \code{diff_mean_est_ci} three-dimensional statistic.
\item For \code{a_lsmeans}, a \code{VertalRowsSection} as returned by \link[rtables:in_rows]{rtables::in_rows}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These functions can be used to produce tables from LS means, e.g. from \code{\link[=fit_mmrm_j]{fit_mmrm_j()}}
or \code{\link[=fit_ancova]{fit_ancova()}}.
}
\section{Functions}{
\itemize{
\item \code{tidy(tern_model)}: Helper method (for \code{\link[broom:reexports]{broom::tidy()}}) to prepare a \code{data.frame} from an
\code{tern_model} object containing the least-squares means and contrasts.

\item \code{s_lsmeans()}: Statistics function which is extracting estimates from a tidied least-squares means
data frame.

\item \code{a_lsmeans()}: Formatted Analysis function to be used as \code{afun}

}}
\note{
These functions have been forked from the \code{tern.mmrm} package. Additional features
are:
\itemize{
\item Additional \code{ref_path} argument for tern.mmrm::summarize_lsmeans().
\item The function is more general in that it also works for LS means results from ANCOVA
\item Additional statistic \code{diff_mean_est_ci} is returned
\item P-value sidedness can be chosen
}
}
\examples{
result <- fit_mmrm_j(
  vars = list(
    response = "FEV1",
    covariates = c("RACE", "SEX"),
    id = "USUBJID",
    arm = "ARMCD",
    visit = "AVISIT"
  ),
  data = mmrm::fev_data,
  cor_struct = "unstructured",
  weights_emmeans = "equal"
)

df <- broom::tidy(result)

s_lsmeans(df[8, ], .in_ref_col = FALSE)
s_lsmeans(df[8, ], .in_ref_col = FALSE, alternative = "greater", show_relative = "increase")

dat_adsl <- mmrm::fev_data |>
  dplyr::select(USUBJID, ARMCD) |>
  unique()

basic_table() |>
  split_cols_by("ARMCD") |>
  add_colcounts() |>
  split_rows_by("AVISIT") |>
  analyze(
    "AVISIT",
    afun = a_lsmeans,
    show_labels = "hidden",
    na_str = tern::default_na_str(),
    extra_args = list(
      .stats = c(
        "n",
        "adj_mean_se",
        "adj_mean_ci",
        "diff_mean_se",
        "diff_mean_ci"
      ),
      .labels = c(
        adj_mean_se = "Adj. LS Mean (Std. Error)",
        adj_mean_ci = "95\% CI",
        diff_mean_ci = "95\% CI"
      ),
      .formats = c(adj_mean_se = jjcsformat_xx("xx.x (xx.xx)")),
      alternative = "greater",
      ref_path = c("ARMCD", result$ref_level)
    )
  ) |>
  build_table(
    df = broom::tidy(result),
    alt_counts_df = dat_adsl
  )
}
