% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxreg_multivar.R
\name{summarize_coxreg_multivar}
\alias{summarize_coxreg_multivar}
\title{Layout Generating Function for TEFOS03 and Related Cox Regression Layouts}
\usage{
summarize_coxreg_multivar(
  lyt,
  var,
  variables,
  control = control_coxreg(),
  formats = list(coef_se = jjcsformat_xx("xx.xx (xx.xx)"), hr_est =
    jjcsformat_xx("xx.xx"), hr_ci = jjcsformat_xx("(xx.xx, xx.xx)"), pval =
    jjcsformat_pval_fct(0))
)
}
\arguments{
\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{var}{(\code{string})\cr any variable from the data, because this is not used.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{control}{(\code{list})\cr relevant list of control options.}

\item{formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{'auto'} setting.}
}
\value{
\code{lyt} modified to add the desired cox regression table section.
}
\description{
Layout Generating Function for TEFOS03 and Related Cox Regression Layouts
}
\examples{
anl <- tern::tern_ex_adtte |>
  dplyr::mutate(EVENT = 1 - CNSR)

variables <- list(
  time = "AVAL",
  event = "EVENT",
  arm = "ARM",
  covariates = c("SEX", "AGE")
)

basic_table() |>
  summarize_coxreg_multivar(
    var = "STUDYID",
    variables = variables
  ) |>
  build_table(df = anl)
}
