% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jpinfect_pivot.R
\name{jpinfect_pivot}
\alias{jpinfect_pivot}
\title{Convert data from wide format to long format for easier analysis}
\usage{
jpinfect_pivot(dataset)
}
\arguments{
\item{dataset}{A data frame containing the columns `prefecture`, `year`, `week`, `date`
and additional columns for diseases and their associated case counts.}
}
\value{
A data frame that is pivoted either to a long or wide format, depending on the number of columns.
If `prefecture`, `year`, `week` or `date` are missing from the dataset, the function stops with an error.
}
\description{
This function pivots a dataset between long and wide formats based on the column count.
If the dataset has 5 or fewer columns, it is pivoted to a wide format, keeping
`prefecture`, `year`, `week` and `date` as fixed identifiers. If the dataset has more than 5 columns,
it is pivoted to a long format.
}
\details{
- If the dataset has 5 or fewer columns, the function uses `pivot_wider()` to convert
  the dataset to a wide format.
- If the dataset has more than 5 columns, the function uses `pivot_longer()` to convert
  the dataset to a long format.
- The function ensures that the columns `prefecture`, `year`, `week` and `date` are always present.
}
\examples{
\donttest{
# Pivot the dataset
result <- jpinfect_pivot(place_prefecture)
print(result)
}

}
