% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jalLeap.R
\name{jalLeap}
\alias{jalLeap}
\title{Determine Leap Year and First Day of Jalaali Year}
\usage{
jalLeap(yearJ)
}
\arguments{
\item{yearJ}{An integer representing the Jalaali (Persian) year.}
}
\value{
A named list with the following elements:
\item{leap}{An integer: 0 if the Jalaali year is a leap year and 1, 2 or 3
if the Jallai year is a common year.}
\item{GregorianYear}{The corresponding Gregorian year.}
\item{MarchDay}{The Gregorian calendar day in March when the Jalaali year starts.}
}
\description{
Based on the work by Kazimierz M. Borkowski (1996), this function determines
whether a given Jalaali (Persian) year is a leap year and calculates the
corresponding Gregorian year and the day in March when the Jalaali New Year
(Nowruz) begins.
}
\details{
The Jalaali calendar is a solar calendar with an irregular leap year cycle,
designed to align closely with the vernal equinox. Unlike the Gregorian
calendar, which follows a fixed leap year rule, the Jalaali leap years are
determined by a more complex astronomical system:

- A typical cycle lasts 33 years, with leap years occurring in years that
  leave a remainder of 1, 5, 9, 13, 17, 22, 26, or 30 when divided by 33.
- The cycle is occasionally disrupted by "break years," which adjust for
  small differences between the astronomical year and the calculated calendar.
- This function follows the leap year calculations and algorithm established by
  Kazimierz M. Borkowski (1996), who analysed equinox timings from AD 550 to
  3800.
}
\examples{
# Check if 1403 is a leap year and get the start date of Nowruz
result <- jalLeap(1403)
print(result)

}
\references{
- Borkowski, K. M. (1996). The Persian calendar for 3000 years.
  *Earth, Moon, and Planets*, 74, 223–230.
  [doi:10.1007/BF00055188](https://doi.org/10.1007/BF00055188)
}
\author{
Abdollah Jalilian
}
