% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_coef_sd.R
\name{coef_sd.pk}
\alias{coef_sd.pk}
\title{Get coefficient standard deviations}
\usage{
\method{coef_sd}{pk}(obj, model = NULL, method = NULL, suppress.messages = TRUE, ...)
}
\arguments{
\item{obj}{A [pk] object.}

\item{model}{Optional: Specify one or more of the fitted models whose
coefficients to return. If NULL (the default), coefficients will be
returned for all of the models in `obj$stat_model`.}

\item{method}{Optional: Specify one or more of the [optimx::optimx()] methods
whose coefficients to return. If NULL (the default), coefficients will be
returned for all of the models in `obj$pk_settings$optimx$method`.}

\item{suppress.messages}{Logical. `TRUE` (the default) to suppress
informative messages. `FALSE` to see them.}

\item{...}{Additional arguments. Not in use right now.}
}
\value{
A dataframe with one row for each `data_group`, `model` and `method`.
  The remaining columns include the parameters & hyperparameters as returned
  by [coef.pk()], as well as their calculated standard deviations. Note that this
  will only return parameters that where optimized.
}
\description{
Extract coefficient/parameter standard deviations from a fitted `pk` object
}
\details{
The coefficient standard deviations are estimated by computing a numerical
approximation to the model Hessian (the matrix of second derivatives of the
model objective function with respect to each model parameter) and then
attempting to invert it. This procedure yields a variance/covariance matrix
for the model parameters. The square root of the diagonal elements of this
matrix represent the parameter standard deviations.

A first attempt is made to invert the Hessian using [solve()] (see
[hess_sd1()]). If the Hessian is singular, an attempt is made to calculate a
pseudovariance matrix, following the procedure outlined in Gill & King (2004)
(see [hess_sd2()]). First, the generalized inverse of the Hessian is calculated using
[MASS::ginv()]. Then, a generalized Cholesky decomposition (to ensure
positive-definiteness) is calculated using [Matrix::Cholesky] with argument
`perm = TRUE`. The generalized inverse is reconstructed from the generalized
Cholesky factorization. The square root of the diagonal elements of this
matrix represent the parameter standard deviations.

If neither of these procedures is successful, then `NA_real_` is returned for
all coefficient standard deviations.
}
\references{
Gill J, King G. (2004) What to Do When Your Hessian is Not
  Invertible: Alternatives to Model Respecification in Nonlinear Estimation.
  Sociological Methods & Research 33(1):54-87. DOI: 10.1177/0049124103262681
}
\seealso{
Other methods for fitted pk objects: 
\code{\link{AAFE.pk}()},
\code{\link{AFE.pk}()},
\code{\link{AIC.pk}()},
\code{\link{BIC.pk}()},
\code{\link{coef.pk}()},
\code{\link{eval_tkstats.pk}()},
\code{\link{get_fit.pk}()},
\code{\link{get_hessian.pk}()},
\code{\link{get_tkstats.pk}()},
\code{\link{logLik.pk}()},
\code{\link{predict.pk}()},
\code{\link{residuals.pk}()},
\code{\link{rmse.pk}()},
\code{\link{rsq.pk}()}
}
\author{
Caroline Ring and Gilberto Padilla Mercado
}
\concept{methods for fitted pk objects}
