% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz-demo-functions.R
\name{demo_idispatch}
\alias{demo_idispatch}
\title{Test the interfacer \code{idispatch} functions}
\usage{
demo_idispatch(x, ...)
}
\arguments{
\item{x}{one of 2 possibilities - EITHER: a dataframe with columns:
\itemize{
\item id (integer) - an integer ID
\item test (logical) - the test result
\item extra (character) - a new value
}

Ungrouped.

OR with columns:
\itemize{
\item id (integer) - an integer ID
\item test (logical) - the test result
}

Any grouping allowed.

}

\item{...}{passed on to methods}
}
\value{
a list of the parameters passed to one of two functions.
}
\description{
Allows testing from the context of an installed package
this is here for testing purposes only. The majority of functions are
tested in \code{testthat} but one or two need package infrastructure to test
things like the documentation
}
\examples{

# When we run examples this should run in an isolated session so
# we might be able to see visibility failures:

# Should dispatch to demo_idispatch.test
test_data = tibble::tibble(
  id = c(1, 2, 3), # this is a numeric vector
  test = c(TRUE, FALSE, TRUE)
)

# Should dispatch to demo_idispatch.test_extn
test_extn_data = tibble::tibble(
  id = c(1, 2, 3),
  test = c(TRUE, FALSE, TRUE),
  extra = c("a", "b", "c"),
  unneeded = c("x", "y", "z")
)

new_a = c(2, 3)
dots_test_value = "true"
tmp = demo_idispatch(test_extn_data, a = new_a, dots_test = dots_test_value)
print(tmp)

# The value was dispatched to the correct function
testthat::expect_equal(tmp$fn, "test_extn")
# The inline value for b was evaluated correctly as `new_a^2`
testthat::expect_equal(tmp$b_value, new_a^2)
# the type was in fact converted during dispatch:
testthat::expect_equal(tmp$types[["id"]], "integer")
testthat::expect_equal(tmp$validates, TRUE)
# dynamic dots were evaluated correctly from this environment
testthat::expect_equal(tmp$dots, list(dots_test = "true"))

tmp2 = demo_idispatch(test_data)
print(tmp2)
testthat::expect_equal(tmp2$a, NULL)
testthat::expect_equal(tmp2$types[["id"]], "integer")
testthat::expect_equal(tmp2$validates, TRUE)
testthat::expect_equal(tmp2$fn, "test")

tmp3 = demo_idispatch(test_data, sym1, sym2, a_expr = sin(pi) + cos(pi))
print(tmp3)

# expression passed correctly as expression:
testthat::expect_equal(tmp3$a_expr, "sin(pi) + cos(pi)")
# expression can be evaluated (in context):
testthat::expect_equal(tmp3$a, -1)
# dots can be handled as symbols:
testthat::expect_equal(
  unname(tmp3$dots),
  lapply(c("sym1", "sym2"), as.symbol)
)

tmp4 = demo_idispatch(test_extn_data, a = class(test_extn_data$id), b = 0)
print(tmp4)
# The reference to class(test_extn_data$id) evaluates on the validated input.
# This is potentially confusing but probably the best option:
testthat::expect_equal(tmp4$a_value, "integer")
testthat::expect_equal(class(test_extn_data$id), "numeric")

}
\keyword{internal}
