% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLA_mismatch_number.R
\name{HLA_mismatch_number}
\alias{HLA_mismatch_number}
\title{HLA_mismatch_number}
\usage{
HLA_mismatch_number(
  GL_string_recip,
  GL_string_donor,
  loci,
  direction,
  homozygous_count = 2
)
}
\arguments{
\item{GL_string_recip}{A GL string representing the recipient's HLA genotype.}

\item{GL_string_donor}{A GL string representing the donor's HLA genotype.}

\item{loci}{A character vector specifying the loci to be considered for
mismatch calculation. HLA-DRB3/4/5 (and their serologic equivalents DR51/52/53)
are considered once locus for this function, and should be called in this argument
as "HLA-DRB3/4/5" or "HLA-DR51/52/53", respectively.}

\item{direction}{A character string indicating the direction of mismatch.
Options are "HvG" (host vs. graft), "GvH" (graft vs. host), "bidirectional"
(the max value of "HvG" and "GvH"), or "SOT" (host vs. graft, as is used for
mismatching in solid organ transplantation).}

\item{homozygous_count}{An integer specifying how to count homozygous mismatches.
Defaults to 2, where homozygous mismatches are treated as two mismatches,
regardless if one or two alleles are supplied in the GL string (in cases
where one allele is supplied, it is duplicated by the function). If
specified as 1, homozygous mismatches are only counted once, regardless of
whether one or two alleles are supplied in the GL string (in cases where
two alleles are supplied, the second identical allele is deleted).}
}
\value{
An integer value or a character string:
- If `loci` includes only one locus, the function returns an integer
mismatch count for that locus.
- If `loci` includes multiple loci, the function returns a character
string in the format "Locus1=Count1, Locus2=Count2, ...".
}
\description{
Calculates the number of mismatched HLA alleles between a
recipient and a donor across specified loci. Supports mismatch calculations
for host-vs-graft (HvG), graft-vs-host (GvH), or bidirectional.
}
\examples{

file <- HLA_typing_1[, -1]
GL_string <- HLA_columns_to_GLstring(file, HLA_typing_columns = everything())

GL_string_recip <- GL_string[1]
GL_string_donor <- GL_string[2]

loci <- c("HLA-A", "HLA-DRB3/4/5", "HLA-DPB1")

# Calculate mismatch numbers (Host vs. Graft)
HLA_mismatch_number(GL_string_recip, GL_string_donor, loci, direction = "HvG")

# Calculate mismatch numbers (Graft vs. Host)
HLA_mismatch_number(GL_string_recip, GL_string_donor, loci, direction = "GvH")

# Calculate mismatch numbers (Bidirectional)
HLA_mismatch_number(GL_string_recip, GL_string_donor,
  loci,
  direction = "bidirectional"
)

}
