% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weo_get_entities.R
\name{weo_get_entities}
\alias{weo_get_entities}
\title{Get Available WEO Entities}
\usage{
weo_get_entities(year = NULL, release = NULL, quiet = TRUE)
}
\arguments{
\item{year}{The year of a WEO publication (e.g., 2024). Defaults to latest
publication year.}

\item{release}{The release of a WEO publication ("Spring" or "Fall").
Defaults to latest publication release.}

\item{quiet}{A logical indicating whether to print download information.
Defaults to TRUE.}
}
\value{
A data frame with columns:
\describe{
\item{entity_id}{ISO3 country code or country group ID}
\item{entity_name}{Full name of the country or country group}
}
}
\description{
Returns a data frame with available entities (countries and country groups)
in the WEO database.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# List all countries and regions
weo_get_entities()
}
\dontshow{\}) # examplesIf}
}
