% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-vol2surf.R
\name{volume_to_surface}
\alias{volume_to_surface}
\title{Create smooth surface from volume mask or data}
\usage{
volume_to_surface(
  volume,
  lambda = 0.2,
  degree = 2,
  threshold_lb = 0.5,
  threshold_ub = NA,
  ...
)
}
\arguments{
\item{volume}{volume object or path to the NIfTI volume files, see
\code{as_ieegio_volume} for details}

\item{lambda, degree}{smooth parameters; see
\code{\link[ravetools]{vcg_smooth_implicit}} for details. To disable
smoothing, set \code{lambda} to negative or \code{NA}}

\item{threshold_lb, threshold_ub}{threshold of volume, see
\code{\link[ravetools]{vcg_isosurface}}; default is any voxel value above 0.5}

\item{...}{passed to \code{as_ieegio_volume}}
}
\value{
A \code{as_ieegio_surface} object; the surface is
transformed into anatomical space defined by the volume.
}
\description{
Create smooth surface from volume mask or data
}
\examples{


# toy example; in practice, use tha path to the volume
volume <- array(0, dim = rep(30, 3))
volume[11:20, 11:20, 3:28] <- 1
volume[3:28, 11:20, 11:20] <- 1
volume[11:20, 3:28, 11:20] <- 1
vox2ras <- diag(1, 4)

surf <- volume_to_surface(volume, vox2ras = vox2ras)

if(interactive()) {
  plot(surf)
}


}
