% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/most_similar.R
\name{most_similar}
\alias{most_similar}
\title{Select the most similar texts to a specific text}
\usage{
most_similar(sample, pool, coefficient, n)
}
\arguments{
\item{sample}{This is a single row of a \code{quanteda} dfm representing the sample to match.}

\item{pool}{This is a dfm containing all possible samples from which to select the top n.}

\item{coefficient}{The coefficient to use for similarity. Either "minmax", "cosine", or "Phi".}

\item{n}{The number of rows to extract from the pool of potential samples.}
}
\value{
The function returns a dfm containing the top n most similar rows to the input sample using the minmax distance.
}
\description{
Select the most similar texts to a specific text
}
\examples{
text1 <- "The cat sat on the mat"
text2 <- "The dog sat on the chair"
text3 <- "Violence is the last refuge of the incompetent"
c <- quanteda::corpus(c(text1, text2, text3))
d <- quanteda::tokens(c) |> quanteda::dfm() |> quanteda::dfm_weight(scheme = "prop")
most_similar(d[1,], d[-1,], coefficient = "minmax", n = 1)

}
