% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate_npfit.R
\name{extend_msfit}
\alias{extend_msfit}
\title{Given a \code{msfit} object, extend the times considered in the object}
\usage{
extend_msfit(msfit, times)
}
\arguments{
\item{msfit}{A \code{msfit} object.}

\item{times}{Times at which to extend the \code{msfit} object.}
}
\value{
An \code{msfit} object containing the extended hazards
}
\description{
After using this function, use probtrans to get interpolated 
transition probabilities. This function is useful when you want to obtain
transition probabilities at more than just the minimal number of times that
strictly have to be considered. The inserted hazard values are simply 
the hazards at the nearest time that is smaller or equal.
}
\examples{
library(mstate)
tmat <- trans.illdeath()
times <- seq(0, 5, 0.1)
ms_fit <- list(Haz = data.frame(time = rep(times, 3),
                                Haz = c(replicate(3, cumsum(runif(length(times), 0, 0.02)))),
                                trans = rep(1:3, each = length(times))),
               trans = tmat)
class(ms_fit) <- "msfit"

ms_fit_interpolated <- extend_msfit(ms_fit, seq(0, 5, 0.01))

}
