% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterLevelDataFrame-methods.R
\name{subset.WaterLevelDataFrame}
\alias{subset.WaterLevelDataFrame}
\title{Subsetting WaterLevelDataFrames}
\usage{
\method{subset}{WaterLevelDataFrame}(x, subset, select, drop = FALSE, ...)
}
\arguments{
\item{x}{object of class \linkS4class{WaterLevelDataFrame}.}

\item{subset}{logical expression indicating elements or rows to keep: missing
values are taken as false.}

\item{select}{expression, indicating columns to select from a data frame.}

\item{drop}{passed on to [ indexing operator.}

\item{\dots}{further arguments to be passed to or from other methods.}
}
\value{
An object similar to x, containing just the selected rows and
  columns. All other slots of the \linkS4class{WaterLevelDataFrame} remain 
  unchanged.
}
\description{
Returns subsets of \linkS4class{WaterLevelDataFrame}s which meet
  conditions.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
wldf <- subset(wldf, station >= 258 & station <= 261)

}
\seealso{
\code{\link[base]{subset}}
}
