% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterLevelDataFrame-methods.R
\name{as.data.frame.WaterLevelDataFrame}
\alias{as.data.frame.WaterLevelDataFrame}
\title{Coerce a WaterLevelDataFrame to a data.frame}
\usage{
\method{as.data.frame}{WaterLevelDataFrame}(x, ...)
}
\arguments{
\item{x}{an object of class \linkS4class{WaterLevelDataFrame}.}

\item{\dots}{additional arguments to be passed to the internally used
\code{\link[base]{as.data.frame}}-function.}
}
\value{
\code{as.data.frame} returns a \code{\link[base]{data.frame}}.
}
\description{
A function to coerce an object of class 
  \linkS4class{WaterLevelDataFrame} to a \code{\link[base]{data.frame}}.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
df <- as.data.frame(wldf)

}
\seealso{
\code{\linkS4class{WaterLevelDataFrame}}, 
  \code{\link[base]{data.frame}}, \code{\link[base]{as.data.frame}}
}
