% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-cell.R
\name{rotation}
\alias{rotation}
\alias{rotation<-}
\alias{set_rotation}
\alias{map_rotation}
\title{Rotate text within cells}
\usage{
rotation(ht)

rotation(ht) <- value

set_rotation(ht, row, col, value)

map_rotation(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A numeric vector or matrix. Set to \code{NA} to reset to the default, which is \code{0}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}
}
\description{
Numbers represent degrees to rotate text anti-clockwise:
}
\details{
\itemize{
\item 0 is the default;
\item 90 is going upwards, for left-to-right languages;
\item 270 is going downwards.
}

You will probably need to set \code{\link[=col_width]{col_width()}} and \code{\link[=row_height]{row_height()}} explicitly
to achieve a nice result, in both HTML and LaTeX.
}
\examples{
rotation(jams) <- 90
rotation(jams)

jams2 <- set_rotation(
  jams,
  270
)
rotation(jams2)

jams3 <- set_rotation(
  jams,
  2:3, 1, 270
)
rotation(jams3)

jams4 <- map_rotation(
  jams,
  by_rows(
    270,
    90
  )
)
rotation(jams4)

}
