% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upload-file.r
\name{upload_file}
\alias{upload_file}
\title{Upload a file with \code{\link[=POST]{POST()}} or \code{\link[=PUT]{PUT()}}.}
\usage{
upload_file(path, type = NULL)
}
\arguments{
\item{path}{path to file}

\item{type}{mime type of path. If not supplied, will be guess by
\code{\link[mime:guess_type]{mime::guess_type()}} when needed.}
}
\description{
Upload a file with \code{\link[=POST]{POST()}} or \code{\link[=PUT]{PUT()}}.
}
\examples{
citation <- upload_file(system.file("CITATION"))
\dontrun{
POST("http://httpbin.org/post", body = citation)
POST("http://httpbin.org/post", body = list(y = citation))
}
}
