% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsphase.R
\name{.phfnoGenotype}
\alias{.phfnoGenotype}
\title{Phase half-sib paternal haplotype using blocks and sire haplotypes (no offspring genotype needed)}
\usage{
.phfnoGenotype(blockMatrix, sirePhasedMatrix)
}
\arguments{
\item{blockMatrix}{An integer/numeric matrix of block assignments with
individuals in rows and markers in columns. Must contain only `0`, `1`, and `2`,
where `0` indicates unknown origin.}

\item{sirePhasedMatrix}{An integer/numeric matrix with **two rows** (the sire
haplotypes) and the same number of columns as \code{blockMatrix}. Must contain
only `0`, `1`, and `9` (where `9` indicates missing).}
}
\value{
An integer matrix with the same dimensions as \code{blockMatrix},
containing the inferred paternal haplotype allele for each individual and
marker. Values are `0`/`1` for alleles and `9` for missing/unknown (e.g. where
\code{blockMatrix} is `0`).
}
\description{
Internal helper that constructs a half-sib paternal haplotype matrix using:
\itemize{
  \item a block/strand-of-origin matrix (typically produced by \code{\link{bmh}})
  \item a 2-row phased sire haplotype matrix (typically produced by \code{\link{ssp}})
}
}
\details{
For each marker (column) and individual (row), if the block code is:
\itemize{
  \item `1`: assign sire haplotype row 1 allele at that marker
  \item `2`: assign sire haplotype row 2 allele at that marker
  \item `0`: leave as missing (`9`)
}

This function calls a native C routine (\code{phaseNogenotype}) via
\code{.C()}.


The underlying C implementation initializes the entire result matrix to `9`
and then fills entries according to \code{blockMatrix}:
\itemize{
  \item if \code{blockMatrix[j,i] == 1}, then \code{result[j,i] = sirePhasedMatrix[1,i]}
  \item if \code{blockMatrix[j,i] == 2}, then \code{result[j,i] = sirePhasedMatrix[2,i]}
}
}
\keyword{internal}
