\name{cs}
\alias{cs}
\title{Chromosome Splitter}
\description{
Splits the genotype list generated by \code{\link{hss}} into chromosomes based on a map file/data.frame and orders SNPs by chromosomal position.
}
\usage{
cs(halfsib, mapPath, separator = " ")
}
\arguments{
  \item{halfsib}{
    \code{list}. List of genotype matrices (one family per list item).
  }
  \item{mapPath}{
    \code{character}  path to the map file  (column 1 -> SNP names, column 2 -> chromosome name and column 3 -> SNP position in base pairs) or, alternatively, the name of a dataframe with the mapping information (in the same format)  
  }
  \item{separator}{
    \code{character}. Field separator for the map file.
  }
}
\details{
The map file should include only the chromosomes that will be analyzed. For example, the Y and X chromosomes should be excluded (and others optionally). Names of each element in the list can be used for further categorization.
The header must be "Name Chr Position".
}
\value{
Returns a list of matrices, the number of elements in this list is the number of half-sib families multiplied by the number of chromosomes.
}
\examples{
# Please run demo(hsphase)
}
\keyword{Chromosome}
\keyword{Splitter}
