% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_grid_to_cell}
\alias{hexify_grid_to_cell}
\title{Convert longitude/latitude to cell ID using a grid object}
\usage{
hexify_grid_to_cell(grid, lon, lat)
}
\arguments{
\item{grid}{Grid specification from hexify_grid()}

\item{lon}{Numeric vector of longitudes in degrees}

\item{lat}{Numeric vector of latitudes in degrees}
}
\value{
Numeric vector of cell IDs (1-based)
}
\description{
Grid-based wrapper for \code{\link{hexify_lonlat_to_cell}}. Converts
geographic coordinates to DGGRID-compatible cell IDs using
the resolution and aperture from a grid object.
}
\examples{
grid <- hexify_grid(area = 1000, aperture = 3)
cell_ids <- hexify_grid_to_cell(grid, lon = c(0, 10), lat = c(45, 50))
}
\seealso{
\code{\link{lonlat_to_cell}} for the recommended S4 interface,
\code{\link{hexify_grid_cell_to_lonlat}} for the inverse operation

Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
