% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_stat_calc.R
\name{SKS_stat_int_cov_pool}
\alias{SKS_stat_int_cov_pool}
\alias{SKS_stat_int_cov}
\title{SKS_stat_int_cov_pool}
\usage{
SKS_stat_int_cov_pool(Y, Z, W, X = NULL)

SKS_stat_int_cov(Y, Z, W, X = NULL)
}
\arguments{
\item{Y}{Observed outcome vector}

\item{Z}{Treatment assigment vector}

\item{W}{Additional pre-treatment covariates to interact with T to define
linear model of treatment effects.}

\item{X}{Additional pre-treatment covariates to adjust for in estimation, but not to interact with treatment.}
}
\description{
SKS_stat_int_cov_pool is a shifted kolmogorov-smirnov statistic with a linear
treatment effect model defined by W. It will attempt to remove any systematic
variation corresponding to W and then return a SKS statistic on the residuals
to measure any variation "left over".

SKS_stat_int_cov() is a Shifted kolmogorov-smirnov statistic with a linear
treatment effect model defined by W. It will attempt to remove any systematic
variation corresponding to W and then return a SKS statistic on the residuals
to measure any variation "left over".
}
\details{
X are _additional_ covariates to adjust for beyond those involved in
treatment effect model.  It will automatically ajust for W as well.  Do not
put a covariate in for both X and W.

This is the test statistic used in Ding, Feller, and Miratrix (2016), JRSS-B.

SKS_stat_int_cov first adjusts for baseline and then models treatment effect
on the residuals to not split treatment effects (see the vignette for more
information on this).

We recommend SKS_stat_int_cov over the "pool" method.
}
\examples{
df <- make_randomized_dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
SKS_stat_int_cov_pool(Y = df$Yobs, Z = df$Z, W = df$A, X = df$B)


df <- make_randomized_dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
SKS_stat_int_cov(Y = df$Yobs, Z = df$Z, W = df$A, X = df$B)

}
