% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonicHMC.R
\name{harmonicHMC}
\alias{harmonicHMC}
\title{Sample from a truncated Gaussian distribution with the harmonic HMC}
\usage{
harmonicHMC(
  nSample,
  burnin = 0,
  mean,
  choleskyFactor,
  constrainDirec,
  constrainBound,
  init,
  time = c(pi/8, pi/2),
  precFlg,
  seed = 1,
  extraOutputs = c()
)
}
\arguments{
\item{nSample}{number of samples after burn-in.}

\item{burnin}{number of burn-in samples (default = 0).}

\item{mean}{a d-dimensional mean vector.}

\item{choleskyFactor}{upper triangular matrix R from Cholesky decomposition of
precision or covariance matrix into R^TR.}

\item{constrainDirec}{the k-by-d F matrix (k is the number of linear constraints).}

\item{constrainBound}{the k-dimensional g vector.}

\item{init}{a d-dimensional vector of the initial value. \code{init} must satisfy all constraints.}

\item{time}{HMC integration time for each iteration. Can either be
a scalar value for a fixed time across all samples, or a length 2 vector of a
lower and upper bound for uniform distribution from which the time is drawn
from for each iteration.}

\item{precFlg}{logical. whether \code{choleskyFactor} is from precision
(\code{TRUE}) or covariance matrix (\code{FALSE}).}

\item{seed}{random seed (default = 1).}

\item{extraOutputs}{vector of strings. "numBounces" and/or "bounceDistances"
can be requested, with the latter containing the distances in-between bounces
for each sample and hence incurring significant computational and memory costs.}
}
\value{
When \code{extraOutputs} is empty (default), returns an \code{nSample}-by-\code{d} matrix of samples.

When \code{extraOutputs} contains \code{"numBounces"} and/or \code{"bounceDistances"}, returns a list with elements:
\item{samples}{\code{nSample}-by-\code{d} matrix of samples}
\item{numBounces}{Vector of bounce counts per sample (if requested)}
\item{bounceDistances}{List of bounce distances per sample (if requested)}
}
\description{
Generate MCMC samples from a d-dimensional truncated Gaussian distribution
with constraints Fx+g >= 0 using the Harmonic Hamiltonian Monte Carlo sampler
(Harmonic-HMC).
}
\examples{
set.seed(1)
d <- 10
A <- matrix(runif(d^2)*2 - 1, ncol=d)
precMat <- t(A) \%*\% A
R <- cholesky(precMat)
mu <- rep(0, d)
constrainDirec <- diag(d)
constrainBound <- rep(0,d)
initial <- rep(1, d)
results <- harmonicHMC(1000, 1000, mu, R, constrainDirec, constrainBound, initial, precFlg = TRUE)
}
\references{
Pakman, A. and Paninski, L. (2014). Exact Hamiltonian Monte Carlo for
Truncated Multivariate Gaussians. Journal of Computational and Graphical
Statistics. doi:10.1080/10618600.2013.788448
}
\seealso{
\code{\link[=getHarmonicSample]{getHarmonicSample()}}, \code{\link[=cholesky]{cholesky()}}, \code{\link[=getInitialPosition]{getInitialPosition()}}
}
