% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonicHMC.R
\name{getHarmonicSample}
\alias{getHarmonicSample}
\title{One-step Harmonic HMC Sampler (Whitened Coordinates)}
\usage{
getHarmonicSample(
  whitenedPosition,
  whitenedConstraints,
  integrationTime,
  diagnosticMode = FALSE,
  seed = NULL
)
}
\arguments{
\item{whitenedPosition}{Position in whitened coordinates}

\item{whitenedConstraints}{List from \code{applyWhitenTransform()}}

\item{integrationTime}{Time for dynamics simulation}

\item{diagnosticMode}{Return bounce diagnostics}

\item{seed}{random seed}
}
\description{
One-step Harmonic HMC Sampler (Whitened Coordinates)
}
\examples{
# Basic usage with whitened coordinates
set.seed(123)
whitened_pos <- c(0.1, -0.2, 0.3)
# Create example whitened constraints
whitened_constraints <- list(
  direc = matrix(c(1, 0, 0, 0, 1, 0), nrow = 2, byrow = TRUE),
  direcRowNormSq = c(1, 1),
  bound = c(-0.5, -0.5)
)
result <- getHarmonicSample(
  whitenedPosition = whitened_pos,
  whitenedConstraints = whitened_constraints,
  integrationTime = pi/4
)
result

# With diagnostics enabled
result_diag <- getHarmonicSample(
  whitenedPosition = whitened_pos,
  whitenedConstraints = whitened_constraints,
  integrationTime = pi/4,
  diagnosticMode = TRUE
)
str(result_diag)
}
\seealso{
\code{\link[=harmonicHMC]{harmonicHMC()}}
}
