% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oscillation.R
\name{oscillation}
\alias{oscillation}
\alias{oscillation.MTD}
\alias{oscillation.default}
\title{Oscillations of an MTD Markov chain}
\usage{
oscillation(x, ...)

\method{oscillation}{MTD}(x, ...)

\method{oscillation}{default}(x, S, A = NULL, ...)
}
\arguments{
\item{x}{Either an MTD model object, an MTDest fit, or a chain sample.}

\item{...}{Ignored.}

\item{S}{A numeric vector of distinct positive integers. Represents a set of lags.}

\item{A}{Optional integer vector giving the state space. If omitted, defaults to \code{sort(unique(x))}.}
}
\value{
A named numeric vector of oscillations. If the \code{x} parameter is
an MTD or MTDest object, it will provide the oscillations for each element in
\code{Lambda} (or \code{S} for MTDest). If \code{x} is a chain sample, it
estimates the oscillations for a user-inputted set of lags \code{S}.
}
\description{
Calculates the oscillations of an MTD model object, of an MTDest fit,
or estimates the oscillations of a chain sample.
}
\details{
For an MTD model or an MTDest fit, the oscillation for lag \eqn{j}
(i.e., \eqn{ \{ \delta_j:\ j \in \Lambda \} } for MTD or \eqn{ \{ \delta_j:\ j \in S \} }
for MTDest) is the product of the mixture weight \eqn{\lambda_j} and the
maximum of the total variation distance between the distributions in a
stochastic matrix \eqn{p_j}. That is,
\deqn{\delta_j = \lambda_j\max_{b,c \in \mathcal{A}} d_{TV}(p_j(\cdot | b), p_j(\cdot | c)).}
When \code{x} is an object of class MTD (or MTDest), the quantities \eqn{\Lambda}
(or \eqn{S}), \eqn{\mathcal{A}}, \eqn{\lambda_j}, and \eqn{p_j} are directly available.
In this case, the oscillations can be computed exactly from the model parameters.

Alternatively, when estimating oscillations from data, \code{x} must be a
realization of a chain and \code{S} must be provided as a candidate lag set.
The transition probabilities are then estimated from the sample before
computing the corresponding oscillations.
Let \eqn{\hat{p}(\cdot| x_S)} symbolize an estimated distribution
in \eqn{\mathcal{A}} given a certain past \eqn{x_S} ( which is a sequence of
elements of \eqn{\mathcal{A}} where each element occurred at a lag in \code{S}),
and \eqn{\hat{p}(\cdot|b_jx_S)} an estimated distribution given past \eqn{x_S}
and that the symbol \eqn{b\in\mathcal{A}} occurred at lag \eqn{j}. If \eqn{N}
is the sample size, \eqn{d=}\code{max(S)} and \eqn{N(x_S)} is the number of
times the sequence \eqn{x_S} appeared in the sample, then
\deqn{\delta_j = \max_{c_j,b_j \in \mathcal{A}} \frac{1}{N-d}\sum_{x_{S} \in \mathcal{A}^{S}} N(x_S)d_{TV}(\hat{p}(. | b_jx_S), \hat{p}(. | c_jx_S) )}
is the estimated oscillation for a lag \eqn{j \in \{1,\dots,d\}\setminus}\code{S}.
Note that \eqn{\mathcal{A}^S} is the space of sequences of \eqn{\mathcal{A}}
indexed by \code{S}.
}
\section{Methods (by class)}{
\itemize{
\item \code{oscillation(MTD)}: For an \code{MTD} (or \code{MTDest}) object: computes
\eqn{\delta_j} for all \eqn{j \in \Lambda} (or for all \eqn{j \in S}).

\item \code{oscillation(default)}: For a chain sample: estimates \eqn{\delta_j} for each \eqn{j} in \code{S}.

}}
\examples{
oscillation(MTDmodel(Lambda = c(1, 4), A = c(2, 3)))
oscillation(MTDmodel(Lambda = c(1, 4), A = c(2, 3), lam0 = 0.01, lamj = c(0.49, 0.5),
                      pj = list(matrix(c(0.1, 0.9, 0.9, 0.1), ncol = 2)),
                      single_matrix = TRUE))

}
