% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_garch.R
\name{hcp_garch}
\alias{hcp_garch}
\title{Change Finder using GARCH}
\usage{
hcp_garch(sw_size = 5)
}
\arguments{
\item{sw_size}{Sliding window size}
}
\value{
\code{hcp_garch} object
}
\description{
Change-point detection is related to event/trend change detection. Change Finder GARCH detects change points based on deviations relative to linear regression model \url{doi:10.1109/TKDE.2006.1599387}.
It wraps the GARCH model presented in the rugarch library.
}
\examples{
library(daltoolbox)

# Load change-point example data
data(examples_changepoints)

# Use a volatility example
dataset <- examples_changepoints$volatility
head(dataset)

# Configure ChangeFinder-GARCH detector
model <- hcp_garch()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected change points
print(detection[(detection$event),])

}
\references{
\itemize{
\item Ogasawara, E., Salles, R., Porto, F., Pacitti, E. Event Detection in Time Series. 1st ed.
Cham: Springer Nature Switzerland, 2025. doi:10.1007/978-3-031-75941-3
}
}
