% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gutenberg_cache.R
\name{gutenberg_cache_dir}
\alias{gutenberg_cache_dir}
\title{Get the active cache directory path}
\usage{
gutenberg_cache_dir()
}
\value{
A character string representing the path to the cache directory.
}
\description{
Calculates the path to the directory where Gutenberg files are stored,
based on the current \code{gutenbergr_cache_type} and \code{gutenbergr_base_cache_dir}
options.
}
\section{Cache options}{

The following options control caching behavior:
\itemize{
\item \code{gutenbergr_cache_type}: Character string indicating how downloaded works
are cached. Must be either \code{"session"} (default) or \code{"persistent"}.
\item \code{gutenbergr_base_cache_dir}: Base directory used for persistent caching when
\code{gutenbergr_cache_type = "persistent"}.
By default, this is an OS-specific cache directory determined by
\code{tools::R_user_dir("gutenbergr", "cache")}. Advanced users may set this
to a custom path.
}
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Get current cache directory
gutenberg_cache_dir()
\dontshow{\}) # examplesIf}
}
\keyword{cache}
