% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_unified.R
\name{fit_model}
\alias{fit_model}
\alias{fit_dk}
\alias{fit_nodk}
\title{Goodness of fit statistics for transition matrix data}
\usage{
fit_model(pre_test, pst_test, g, est.param, force9 = FALSE)

fit_dk(pre_test, pst_test, g, est.param, force9 = FALSE)

fit_nodk(pre_test, pst_test, g, est.param)
}
\arguments{
\item{pre_test}{data.frame carrying pre_test items}

\item{pst_test}{data.frame carrying pst_test items}

\item{g}{estimates of gamma produced from \code{\link{lca_cor}}}

\item{est.param}{estimated parameters produced from \code{\link{lca_cor}}}

\item{force9}{Optional. Force 9-column format even if no DK responses. Default is FALSE.}
}
\value{
matrix with two rows: top row carrying chi-square value, bottom row p-values
}
\description{
Chi-square goodness of fit between true and model based multivariate distribution.
Handles both data with and without don't know responses automatically.
}
\details{
Unified Goodness of Fit Statistics
}
\examples{
\dontrun{
# Fit model first
transmatrix <- multi_transmat(pre_test, pst_test)
res <- lca_cor(transmatrix)

# Calculate goodness of fit
fit_stats <- fit_model(pre_test, pst_test, res$param.lca[nrow(res$param.lca), ], 
                       res$param.lca[-nrow(res$param.lca), ])
}
}
