% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather_ard.R
\name{gather_ard}
\alias{gather_ard}
\title{Extract ARDs}
\usage{
gather_ard(x)
}
\arguments{
\item{x}{(\code{gtsummary})\cr a gtsummary table.}
}
\value{
list
}
\description{
Extract the ARDs from a gtsummary table. If needed, results may be combined
with \code{cards::bind_ard()}.
}
\examples{
\dontshow{if (gtsummary:::is_pkg_installed('cardx')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tbl_summary(trial, by = trt, include = age) |>
  add_overall() |>
  add_p() |>
  gather_ard()

glm(response ~ trt, data = trial, family = binomial()) |>
  tbl_regression() |>
  gather_ard()
\dontshow{\}) # examplesIf}
}
