% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n.R
\name{add_n_summary}
\alias{add_n_summary}
\alias{add_n.tbl_summary}
\alias{add_n.tbl_svysummary}
\alias{add_n.tbl_likert}
\title{Add column with N}
\usage{
\method{add_n}{tbl_summary}(
  x,
  statistic = "{N_nonmiss}",
  col_label = "**N**",
  footnote = FALSE,
  last = FALSE,
  ...
)

\method{add_n}{tbl_svysummary}(
  x,
  statistic = "{N_nonmiss}",
  col_label = "**N**",
  footnote = FALSE,
  last = FALSE,
  ...
)

\method{add_n}{tbl_likert}(
  x,
  statistic = "{N_nonmiss}",
  col_label = "**N**",
  footnote = FALSE,
  last = FALSE,
  ...
)
}
\arguments{
\item{x}{(\code{tbl_summary})\cr
Object with class \code{'tbl_summary'} created with \code{\link[=tbl_summary]{tbl_summary()}} function.}

\item{statistic}{(\code{string})\cr
String indicating the statistic to report. Default is the
number of non-missing observation for each variable, \code{statistic = "{N_nonmiss}"}.
All statistics available to report include:
\itemize{
\item \code{"{N_obs}"} total number of observations,
\item \code{"{N_nonmiss}"} number of non-missing observations,
\item \code{"{N_miss}"} number of missing observations,
\item \code{"{p_nonmiss}"} percent non-missing data,
\item \code{"{p_miss}"} percent missing data
}

The argument uses \code{\link[glue:glue]{glue::glue()}} syntax and multiple statistics may be reported,
e.g. \code{statistic = "{N_nonmiss} / {N_obs} ({p_nonmiss}\%)"}}

\item{col_label}{(\code{string})\cr
String indicating the column label.  Default is \code{"**N**"}}

\item{footnote}{(scalar \code{logical})\cr
Logical argument indicating whether to print a footnote
clarifying the statistics presented. Default is \code{FALSE}}

\item{last}{(scalar \code{logical})\cr
Logical indicator to include N column last in table.
Default is \code{FALSE}, which will display N column first.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A table of class \code{c('tbl_summary', 'gtsummary')}
}
\description{
For each variable in a \code{tbl_summary} table, the \code{add_n} function adds a column with the
total number of non-missing (or missing) observations
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed("survey")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
trial |>
  tbl_summary(by = trt, include = c(trt, age, grade, response)) |>
  add_n()

# Example 2 ----------------------------------
survey::svydesign(~1, data = as.data.frame(Titanic), weights = ~Freq) |>
  tbl_svysummary(by = Survived, percent = "row", include = c(Class, Age)) |>
  add_n()
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
