% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{constants}
\alias{constants}
\title{The fundamental physical constants}
\format{
A tibble with 354 rows and 4 variables:
\describe{
\item{name}{The name of the constant.}
\item{value}{The value of the constant.}
\item{uncert}{The uncertainty associated with the value. If \code{NA} then the
value is seen as an 'exact' value (e.g., an electron volt has the exact value
of 1.602 176 634 e-19 J).}
\item{sf_value,sf_uncert}{The number of significant figures associated with
the value and any uncertainty value.}
\item{units}{The units associated with the constant.}
}
}
\usage{
constants
}
\description{
This dataset contains values for over 300 basic fundamental constants in
nature. The values originate from the 2018 adjustment which is based on the
latest relevant precision measurements and improvements of theoretical
calculations. Such work has been carried out under the authority of the
\emph{Task Group on Fundamental Constants} (TGFC) of the
\emph{Committee on Data of the International Science Council} (CODATA). These
updated values became available on May 20, 2019. They are published at
\url{https://physics.nist.gov/cuu/Constants/index.html}, a website of the
\emph{Fundamental Constants Data Center} of the
\emph{National Institute of Standards and Technology} (NIST), Gaithersburg,
Maryland, USA.
}
\section{Dataset ID and Badge}{

DATA-12

\if{html}{\out{
<div style="text-align:center;"><img src="https://raw.githubusercontent.com/rstudio/gt/master/images/dataset_constants.png" alt="This image of that of a dataset badge." style="width:50\%;padding-bottom:20px;"></div>
}}
}

\section{Dataset Introduced}{

\code{v0.10.0} (October 7, 2023)
}

\examples{
dplyr::glimpse(constants)
}
\seealso{
Other datasets: 
\code{\link{countrypops}},
\code{\link{exibble}},
\code{\link{films}},
\code{\link{gibraltar}},
\code{\link{gtcars}},
\code{\link{illness}},
\code{\link{metro}},
\code{\link{nuclides}},
\code{\link{peeps}},
\code{\link{photolysis}},
\code{\link{pizzaplace}},
\code{\link{reactions}},
\code{\link{rx_addv}},
\code{\link{rx_adsl}},
\code{\link{sp500}},
\code{\link{sza}},
\code{\link{towny}}
}
\concept{datasets}
\keyword{datasets}
