% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.c.R
\name{find.c}
\alias{find.c}
\title{Function to solve for a group sequential critical value at a given stage}
\usage{
find.c(previous.c, pi, corr)
}
\arguments{
\item{previous.c}{Numeric value giving the critical boundary from the previous analysis stage.}

\item{pi}{Target incremental Type I error to be spent at the current stage.}

\item{corr}{Correlation matrix of the joint multivariate normal distribution of test statistics across analyses.}
}
\value{
A numeric value giving the critical boundary \code{c} at the current analysis stage that satisfies the
specified Type I spending constraint.
}
\description{
Computes the critical boundary value at the current analysis stage by solving a probability
equation under a multivariate normal distribution. The boundary is chosen so that the incremental Type I error spent
at the current stage equals a specified target value, conditional on previously determined boundaries.
}
