% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSample.Q.Cov.Estimator.Sequential.GT.R
\name{TwoSample.Q.Cov.Estimator.Sequential.GT}
\alias{TwoSample.Q.Cov.Estimator.Sequential.GT}
\title{Function to calculate stage-wise test statistics, variances, and correlation for two-sample generalized-t statistics.}
\usage{
TwoSample.Q.Cov.Estimator.Sequential.GT(data, tau = 3, calendars)
}
\arguments{
\item{data}{A data.frame generated by \code{TwoSample.generate.sequential()}.}

\item{tau}{Positive numeric value specifying the upper bound of event time
(time since enrollment) for integration of the statistic. Default is
\code{3}.}

\item{calendars}{Numeric vector of interim analysis calendar times (in years)
at which to compute stage-wise statistics and variance estimates.}
}
\value{
A list containing stage-wise estimates. If \code{length(calendars) > 1},
the returned list includes:
\itemize{
  \item \code{Qs}: Numeric vector of stage-wise generalized-t statistics
    evaluated at each calendar time in \code{calendars}.
  \item \code{vars}: Numeric vector of estimated variances corresponding to
    \code{Qs}.
  \item \code{total.ns}: Numeric vector giving the total enrolled sample size
    contributing data at each calendar time.
  \item \code{corr.matrix}: Estimated correlation matrix of the stage-wise
    statistics.
  \item \code{nss}: List of length \code{length(calendars)} giving the
    group-specific sample sizes at each analysis.
}
If \code{length(calendars) == 1}, the list contains \code{Qs}, \code{vars},
and \code{total.ns}.
}
\description{
Computes the stage-wise generalized-t statistics and their variance estimates at a set of interim analysis
calendar times. At each analysis, administrative censoring is applied at the specified calendar time, event times are converted from the
calendar-time scale to the event-time scale (time since enrollment), and the generalized-t statistics is
evaluated over \code{[0, tau]}. When multiple analysis are requested, the function also estimates the correlation
matrix of the stage-wise statistics.
}
\examples{
\donttest{
df <- TwoSample.generate.sequential(sizevec = c(200, 200), beta.trt = 0,
calendar = 5, recruitment = 3, random.censor.rate = 0.05, seed = 2026)
TwoSample.Q.Cov.Estimator.Sequential.GT(data = df, calendars = c(2.5, 3.5, 4.5))
}
}
