% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Onesample.generate.sequential.R
\name{Onesample.generate.sequential}
\alias{Onesample.generate.sequential}
\title{Function to simulate one-sample composite endpoint data under staggered entry.}
\usage{
Onesample.generate.sequential(
  beta = c(0, 0),
  lambda_0 = 1.15,
  size,
  recruitment = 3,
  calendar = 5,
  random.censor.rate,
  seed
)
}
\arguments{
\item{beta}{Regression coefficient vector for the proportional mean functions, the default is \code{c(0,0)}, corresponds to no covariates effects.}

\item{lambda_0}{Rate parameter for the underlying Poisson process, default is \code{1.15} for a mean frequeny of 2 at \code{t=2}.}

\item{size}{Total sample size.}

\item{recruitment}{Length of the recruitment period (in years), default is \code{3}.}

\item{calendar}{Calendar time of the end of the trial (in years), default is \code{5}.}

\item{random.censor.rate}{Rate parameter for independent random right censoring.}

\item{seed}{Seed for reproducibility.}
}
\value{
A data frame in long format containing simulated composite endpoint data.
Each subject may contributing multiple rows corresponding to recurrent events, a terminal event (death), or censoring. The data include:
\itemize{
\item \code{id}: Subject identifier.
\item \code{e}: Enrollment time on the calendar scale.
\item \code{event_time_cal}: Cumulative event time on the calendar scale.
\item \code{status}: Event indicator with values
\code{2}=recurrent event, \code{1}=death, and \code{0}=censoring.
\item \code{Z1}, \code{Z2}: Simulated covariates used in the proportional mean model.
\item \code{tau_star}: Subject-specific stopping time, the last event observed in \code{[0, tau_star]} is classified as death.
\item \code{death}: Binary indicator for death.
\item \code{recurrent}: Binary indicator for recurrent events.
\item \code{event}: Binary event indicator, \code{event = death + recurrent}.
\item \code{calendar}: Calendar time cutoff used to generate the returned data.
\item \code{lambda_0}: Baseline Poisson process rate parameter.
\item \code{lambda_star}: Rate parameter of an exponential distribution in generating \code{tau_star}.
\item \code{gamma_scale}, \code{gamma_shape}: Parameters of the Gamma distribution used to generate subject-specific frailty terms.
}
}
\description{
Simulate one-sample composite endpoints data with recurrent events and a terminal event
under two time scales: event time \code{t} and calendar time \code{s}. A uniform recruitment period is assumed,
and the function returns all observed data available at a specified calendar time. Recurrent event occurrences
are generated from an underlying Poisson process with subject-specific Gamma frailty.
}
\examples{
# Generate one-sample composite endpoint data
df <- Onesample.generate.sequential(size = 200,
recruitment = 3, calendar = 5,
random.censor.rate = 0.05, seed = 1123)
}
\references{
Mao L, Lin DY. Semiparametric regression for the weighted composite endpoint of recurrent and terminal events. \emph{Biostatistics}. 2016 Apr; \strong{17(2)} :390-403.
}
