% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Apply.calendar.censoring.R
\name{Apply.calendar.censoring}
\alias{Apply.calendar.censoring}
\title{Function to apply a given calendar time as effective censoring time.}
\usage{
Apply.calendar.censoring(data, calendar)
}
\arguments{
\item{data}{A data frame containing simulated composite endpoint data generated by \code{Onesample.generate.sequential()}.}

\item{calendar}{A positive numeric value specifying the calendar time (in years) at which administrative censoring is applied.}
}
\value{
A data frame in long format containing the censored composite endpoint data. Each subject contributes all events occurring
on or before the specified calendar time, with an additional censoring record added for subjects who have not
experienced a terminal event by that time.
}
\description{
Applies administrative censoring at a specified calendar time by truncating each subject's observed
event history. For subjects who are still under observation at the calendar cutoff, a censoring record is added
at the specified calendar time.
}
\examples{
df <- Onesample.generate.sequential(size = 200, recruitment = 3,
calendar = 5, random.censor.rate = 0.05, seed = 1123)
df2 <- Apply.calendar.censoring(data = df, calendar = 4)
}
