% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_gs_bound.R
\name{check_gs_bound}
\alias{check_gs_bound}
\title{Check group sequential bounds}
\usage{
check_gs_bound(sim_results, design, info_scale = c("blinded", "unblinded"))
}
\arguments{
\item{sim_results}{Data frame of simulation results (from \code{\link[=sim_gs_nbinom]{sim_gs_nbinom()}}).}

\item{design}{The planning \code{gsNB} object.}

\item{info_scale}{Character. "blinded" (default) or "unblinded" information to use for bounds.}
}
\value{
A data frame with added columns:
\describe{
\item{cross_upper}{Logical, true if upper bound crossed (efficacy)}
\item{cross_lower}{Logical, true if lower bound crossed (futility)}
}
}
\description{
Updates the group sequential design boundaries based on observed information
and checks if boundaries have been crossed.
}
\examples{
design <- gsDesign::gsDesign(k = 2, n.fix = 100, test.type = 2, timing = c(0.5, 1))
sim_df <- data.frame(
  sim = c(1, 1, 2, 2),
  analysis = c(1, 2, 1, 2),
  z_stat = c(2.5, NA, -0.2, 2.2),
  blinded_info = c(50, 100, 50, 100),
  unblinded_info = c(50, 100, 50, 100)
)
check_gs_bound(sim_df, design)
}
