% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridify-classes.R
\name{gridifyCell}
\alias{gridifyCell}
\title{Create a gridifyCell}
\usage{
gridifyCell(
  row,
  col,
  text = character(0),
  mch = Inf,
  x = 0.5,
  y = 0.5,
  hjust = 0.5,
  vjust = 0.5,
  rot = 0,
  gpar = grid::gpar()
)
}
\arguments{
\item{row}{A numeric value, span or a sequence specifying the range of occupied rows of the cell.}

\item{col}{A numeric value, span or a sequence specifying the range of occupied columns of the cell.}

\item{text}{A character value specifying the default text for the cell.
Default \code{character(0)}.}

\item{mch}{A numeric value specifying the maximum number of characters per line.
The functionality is based on the \code{strwrap} function.
By default, it avoids breaking up words and only splits lines when specified.
Default \code{Inf}.}

\item{x}{A numeric value specifying the x position of text in the cell.
Default \code{0.5}.}

\item{y}{A numeric value specifying the y position of text in the cell.
Default \code{0.5}.}

\item{hjust}{A numeric value specifying the horizontal position of the text in the cell, relative to the x value.
Default \code{0.5}.}

\item{vjust}{A numeric value specifying the vertical position of the text in the cell, relative to the y value.
Default \code{0.5}.}

\item{rot}{A numeric value specifying the rotation of the cell.
Default \code{0}.}

\item{gpar}{A \code{grid::gpar()} object specifying the graphical parameters of the cell.
Default \code{grid::gpar()}.}
}
\value{
An instance of the gridifyCell class.
}
\description{
Function for creating a new instance of the gridifyCell class.
Multiple gridifyCell objects are inputs for gridifyCells.
}
\examples{
cell <- gridifyCell(
  row = 1,
  col = 1:2,
  text = "Default cell text",
  mch = Inf,
  x = 0.5,
  y = 0.5,
  hjust = 0.5,
  vjust = 0.5,
  rot = 0,
  gpar = grid::gpar()
)
}
\seealso{
\code{\link[=gridifyCells]{gridifyCells()}}, \code{\link[=gridifyLayout]{gridifyLayout()}}
}
