% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotGeneGroupsBars}
\alias{PlotGeneGroupsBars}
\title{Plot gene values as bars}
\usage{
PlotGeneGroupsBars(
  data,
  gene,
  slot = DefaultSlot(data),
  columns = NULL,
  show.CI = FALSE,
  xlab = NULL,
  transform = NULL
)
}
\arguments{
\item{data}{the grandR object to get the data to be plotted from}

\item{gene}{the gene to plot}

\item{slot}{the slot of the grandR object to get the data from}

\item{columns}{which columns (i.e. samples or cells) to show (see details)}

\item{show.CI}{show confidence intervals; one of TRUE/FALSE (default: FALSE)}

\item{xlab}{The names to show at the x axis;}

\item{transform}{function that is called on the data frame directly before plotting (can be NULL)}
}
\value{
a ggplot object.
}
\description{
Plot old and new RNA of a gene in a row.
}
\details{
xlab can be given as a character vector or an expression that evaluates into a character vector.
The expression is evaluated in an environment having the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently it.

Columns can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment having the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition=="x").
}
\seealso{
\link{GetData}, \link{PlotGeneTotalVsNtr},\link{PlotGeneOldVsNew},\link{PlotGeneGroupsBars}
}
\concept{geneplot}
