% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{ComputeAbsolute}
\alias{ComputeAbsolute}
\title{Compute absolute expression using ERCC spike ins}
\usage{
ComputeAbsolute(
  data,
  dilution = 40000,
  volume = 10,
  slot = "tpm",
  name = "absolute"
)
}
\arguments{
\item{data}{the grandR object}

\item{dilution}{the dilution of the spikein transcript in the lysis reaction mix}

\item{volume}{the approximate volume of the lysis chamber (nanoliters)}

\item{slot}{the slot containing relative expression values}

\item{name}{the name of the new slot to put absolute expression values in}
}
\value{
a new grandR object with an additional slot
}
\description{
Compute absolute expression in a grandR object and puts the normalized data into a new slot
}
\seealso{
\link[monocle]{relative2abs}
}
\concept{preprocess}
