% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{server}
\alias{server}
\title{Run basic GraphQL server with GraphiQL support}
\usage{
server(
  schema,
  port = 8000L,
  ...,
  graphiql = interactive(),
  log = TRUE,
  initial_value = NULL
)
}
\arguments{
\item{schema}{Schema object to use execute requests}

\item{port}{web port to serve the server from.  Set port to \code{NULL} to not run the plumber server and return it.}

\item{...}{ignored for paramter expansion}

\item{graphiql}{logical to determine if the GraphiQL interface should be enabled.  By default, this route is only available when running the server interactively.}

\item{log}{boolean that determines if server logging is done.  Defaults to TRUE}

\item{initial_value}{default value to use in \code{\link[=execute_request]{execute_request()}}}
}
\description{
Run a basic GraphQL server using plumber.  This server is provided to show basic interaction with GraphQL.  The server will run until the function execution is canceled.
}
\details{
To view the GraphiQL user interface, navigate to the URL provided when the server is started.  The default location is \verb{http://localhost:8000/graphiql/}. By default, this route is only available when running the server interactively (\code{graphiql = rlang::is_interactive()}).

\code{server()} implements the basic necessities described in \url{http://graphql.org/learn/serving-over-http/}.  There are four routes implemented:
\itemize{
\item \code{/} (GET) If run interactively, forwards to \verb{/graphiql} for user interaction with the GraphQL server. This route is diabled if \code{graphiql = rlang::is_interactive()} is not \code{TRUE}.
\item \verb{/graphiql/} (GET) Returns a \href{https://github.com/graphql/graphiql/blob/graphiql\%402.2.0/packages/graphiql/README.md}{GraphiQL formatted schema definition} interface to manually interact with the GraphQL server. By default this route is disabled if \code{graphiql = rlang::is_interactive()} is not \code{TRUE}.
\item \verb{/graphql} (GET) Executes a query.  The parameter \code{'query'} (which contains a GraphQL formatted query string) must be included.  Optional parameters include: \code{'variables'} a JSON string containing a dictionary of variables (defaults to an empty named list), \code{'operationName'} name of the particular query operation to execute (defaults to NULL), and \code{'pretty'} boolean to determine if the response should be compact (FALSE, default) or expanded (TRUE)
\item \verb{/graphql} (POST) Executes a query. Must provide Content-Type of either 'application/json' or 'application/graphql'.
\itemize{
\item If 'application/json' is provided, a named JSON list containing 'query', 'operationName' (optional, default = \code{NULL}), 'variables' (optional, default = list()) and 'pretty' (optional, default = \code{TRUE}).  The information will used just the same as the GET-'/graphql' route.
\item If 'application/graphql' is provided, the POST body will be interpreted as the query string.  All other possible parameters will take on their default value.
}
}

Using bash's curl, we can ask the server questions:
\preformatted{ #R
  # load Star Wars schema from 'execute_request' example
  example(gqlr_schema)
  # run server
  server(star_wars_schema, port = 8000)
}

\preformatted{ #bash
  # GET Schema definition
  curl '127.0.0.1:8000/'

  ## POST for R2-D2 and his friends' names
  # defaults to parse as JSON
  curl --data '{"query":"{hero{name, friends { name }}}", "pretty": true}' '127.0.0.1:8000/graphql'
  # send json header
  curl --data '{"query":"{hero{name, friends { name }}}"}' '127.0.0.1:8000/graphql' --header "Content-Type:application/json"
  # send graphql header
  curl --data '{hero{name, friends { name }}}' '127.0.0.1:8000/graphql' --header "Content-Type:application/graphql"
  # use variables
  curl --data '{"query":"query Droid($someId: String!) {droid(id: $someId) {name, friends { name }}}", "variables": {"someId": "2001"}}' '127.0.0.1:8000/graphql'

  # GET R2-D2 and his friends' names
  curl '127.0.0.1:8000/graphql?query=%7Bhero%7Bname%2Cfriends%7Bname%7D%7D%7D&pretty=TRUE'
  # ... using a variable
  curl '127.0.0.1:8000/graphql?query=query%20Droid(%24someId%3A%20String!)%20%7Bdroid(id%3A%20%24someId)%7Bname%2C%20friends%20%7B%20name%20%7D%7D%7D&variables=%7B%22someId%22%3A%222001%22%7D'

}
}
